options(echo=FALSE) # turn off command line output

rundays<-F # run aircoa_raw_day on all days?
cncdays<-F # plot timeseries and profiles for all days in aircoa_conc_days?

# read in programs
source('../../aircoa_raw_day.r') # acrawday(loc='NWR',unit='A',day='050901',outflag='',njog=150,skip=50,ico=0.0,eco=1.0,trh='humitter',png=F,datadir='/scr/raf/stephens/RCDAT',preserve=F)
source('../../aircoa_make_html.r') # acmkhtml(loc='NWR',unit='A',start='050901',end='050907',procday=T,procconc=F,proccomp=F,outflag='',netdir='/net/www/docs/homes/stephens/RACCOON/',remold=T,remall=F)
source('../../aircoa_conc_days.r') # accncdys(loc='NWR',unit='A',startchr='050901',endchr='050907',inflag='',outflag='',pcor=T,tcor=T,fcor=F,ltmpco=0.5,sflco=70,ico=0.0,eco=1.0,png=F,daily=T,nlines=3)
source('../../aircoa_comp.r') # accomp(start='080101',end='080131',locs=c('NWR','FEF','SPL','HDP','EFS','RBA'),outflag='',ico=0.0,eco=1.0,png=F,nlines=c(3,3,3,3,3,3))

system('date',T)

# set up monthly allproc procedure
allproc<-function(loc='NWR',unit='A',firstday='050826',lastday='050831',apc=T,atc=T,asflc=70,askp=50,aico=0.0,aeco=1.0,atrh='humitter',rundays=T,runconc=T,cncdays=T,askup=T,ahdp=F){
start<-paste('1',firstday,sep='')
end<-paste('1',lastday,sep='')
dayblank<-substr(as.character(c(as.numeric(start):as.numeric(end))),2,7)
if(rundays){
	if(length(dayblank)>1){
		acrawday(loc,unit,dayblank[1],skip=askp,ico=aico,trh=atrh)
		acmkhtml(loc,unit,'',dayblank[1])
		if(length(dayblank)>2){
			for(day in dayblank[2:(length(dayblank)-1)]){
				acrawday(loc,unit,day,skip=askp,trh=atrh)
				acmkhtml(loc,unit,'',day)
			}
		}
		acrawday(loc,unit,dayblank[length(dayblank)],skip=askp,eco=aeco,trh=atrh)
		acmkhtml(loc,unit,'',dayblank[length(dayblank)])
	} else {
		acrawday(loc,unit,dayblank[1],skip=askp,ico=aico,eco=aeco,trh=atrh)
		acmkhtml(loc,unit,'',dayblank[1])
	}
}
if(runconc){
	day0<-dayblank[1]
	day<-dayblank[length(dayblank)]
	accncdys(loc,unit,day0,day,pcor=apc,tcor=atc,sflco=asflc,ico=aico,eco=aeco,daily=cncdays,skipupdate=askup,hdp2009fix=ahdp)
	acmkhtml(loc,unit,day0,day,F,T)
}
}

allproc('NWR','A','050826','050831',rundays=rundays,cncdays=cncdays,askp=75) # use last 75 seconds only
allproc('NWR','A','050901','050910',rundays=rundays,cncdays=cncdays,askp=75,aeco=0.896) # break for line 2/3 switch
allproc('NWR','A','050910','050930',rundays=rundays,cncdays=cncdays,askp=75,aico=0.896)
allproc('NWR','A','051001','051012',rundays=rundays,cncdays=cncdays,askp=75,aeco=0.8) # break for line 2 move to 5.5 m and line 2/3 switch 
allproc('NWR','A','051012','051031',rundays=rundays,cncdays=cncdays,askp=75,aico=0.8)
allproc('NWR','A','051101','051120',rundays=rundays,runconc=F,askp=75) # screen for pump failure
allproc('NWR','A','051123','051130',rundays=rundays,runconc=F)
allproc('NWR','A','051101','051130',rundays=F,cncdays=cncdays)
allproc('NWR','A','051201','051231',rundays=rundays,cncdays=cncdays)
allproc('NWR','A','060118','060131',rundays=rundays,cncdays=cncdays) # screen for warm up
allproc('NWR','A','060201','060228',rundays=rundays,cncdays=cncdays)
allproc('NWR','A','060301','060331',rundays=rundays,cncdays=cncdays)
allproc('NWR','A','060401','060430',rundays=rundays,runconc=F) # break for cylinder swap out (run as 1 w/ future code)
allproc('NWR','A','060401','060405',rundays=F,cncdays=cncdays,aeco=0.65)
allproc('NWR','A','060408','060430',rundays=F,cncdays=cncdays,asflc=-100) # remove sample flow cutoff
allproc('NWR','A','060501','060531',rundays=rundays,cncdays=cncdays)
allproc('NWR','A','060601','060630',rundays=rundays,cncdays=cncdays)
allproc('NWR','A','060701','060707',rundays=rundays,cncdays=cncdays,aeco=0.95) # screen for humidity problem and recovery with dirty optics and bad cal
allproc('NWR','A','060801','060831',rundays=rundays,cncdays=cncdays)
allproc('NWR','A','060901','060915',rundays=rundays,cncdays=cncdays,aeco=0.7) # break for cleaning and recal
allproc('NWR','A','060916','060930',rundays=rundays,cncdays=cncdays) 
allproc('NWR','A','061001','061031',rundays=rundays,cncdays=cncdays)
allproc('NWR','A','061101','061130',rundays=rundays,cncdays=cncdays)
allproc('NWR','A','061201','061202',rundays=rundays,cncdays=cncdays) # only 2 days of data
allproc('NWR','A','070101','070131',rundays=rundays,runconc=F) # break for cylinder swap out (run as 1 w/ future code), also cyls closed period  
allproc('NWR','A','070101','070126',rundays=F,cncdays=cncdays,aeco=0.8)
allproc('NWR','A','070129','070131',rundays=F,cncdays=cncdays)
allproc('NWR','A','070201','070228',rundays=rundays,cncdays=cncdays)
allproc('NWR','A','070301','070331',rundays=rundays,cncdays=cncdays)
allproc('NWR','A','070401','070430',rundays=rundays,cncdays=cncdays)
allproc('NWR','A','070501','070531',rundays=rundays,cncdays=cncdays)
allproc('NWR','A','070601','070630',rundays=rundays,cncdays=cncdays)
allproc('NWR','A','070701','070731',rundays=rundays,cncdays=cncdays) # one bad HS2 that affects LT (get cal-step filter working in acconc)
allproc('NWR','A','070801','070831',rundays=rundays,cncdays=cncdays)
allproc('NWR','A','070901','070913',rundays=rundays,cncdays=cncdays,aeco=0.65) # break for Li820 problem
allproc('NWR','A','071010','071031',rundays=rundays,cncdays=cncdays,aico=0.85) 
allproc('NWR','A','071101','071102',rundays=rundays,cncdays=cncdays,aeco=0.5) # break for LS1 running out
allproc('NWR','A','071117','071130',rundays=rundays,cncdays=cncdays)
allproc('NWR','A','071201','071211',rundays=rundays,cncdays=cncdays) # no data past 11th
allproc('NWR','A','080101','080131',rundays=rundays,cncdays=cncdays)
allproc('NWR','A','080201','080231',rundays=rundays,runconc=F) # break for LT cylinder swap out (run as 1 w/ future code), also cyls closed period  
allproc('NWR','A','080201','080205',rundays=F,cncdays=cncdays)
allproc('NWR','A','080206','080229',rundays=F,cncdays=cncdays) # on 7th and 8th sample and line 2 flows are swapped and 0 flow LTs not rejected
# no data 0803 - 0806
allproc('NWR','A','080701','080731',rundays=rundays,cncdays=cncdays)
allproc('NWR','A','080801','080831',rundays=rundays,cncdays=cncdays)
allproc('NWR','A','080901','080930',rundays=rundays,cncdays=cncdays)
allproc('NWR','A','081001','081031',rundays=rundays,cncdays=cncdays)
allproc('NWR','A','081101','081130',rundays=rundays,cncdays=cncdays)
#allproc('NWR','A','081201','081231',rundays=rundays,runconc=F) # sample pump dead
allproc('NWR','A','090117','090131',rundays=rundays,cncdays=cncdays) # a few hours of bad data on 16th
allproc('NWR','A','090201','090228',rundays=rundays,cncdays=cncdays)
allproc('NWR','A','090301','090331',rundays=rundays,cncdays=cncdays)
allproc('NWR','A','090401','090430',rundays=rundays,runconc=F) # cal gases run out at end of month
allproc('NWR','A','090401','090424',rundays=F,cncdays=cncdays)
allproc('NWR','A','090501','090531',rundays=rundays,runconc=F) # cal gases started up on 13th
allproc('NWR','A','090514','090531',rundays=F,cncdays=cncdays)
allproc('NWR','A','090601','090630',rundays=rundays,cncdays=cncdays)
allproc('NWR','A','090701','090731',rundays=rundays,cncdays=cncdays)
allproc('NWR','A','090801','090831',rundays=rundays,cncdays=cncdays)
allproc('NWR','A','090901','090930',rundays=rundays,cncdays=cncdays)
allproc('NWR','A','091001','091031',rundays=rundays,cncdays=cncdays)
allproc('NWR','A','091101','091130',rundays=rundays,cncdays=cncdays)
allproc('NWR','A','091201','091231',rundays=rundays,cncdays=cncdays)
allproc('NWR','A','100101','100131',rundays=rundays,cncdays=cncdays)
allproc('NWR','A','100201','100228',rundays=rundays,cncdays=cncdays)
allproc('NWR','A','100301','100331',rundays=rundays,cncdays=cncdays)
allproc('NWR','A','100401','100430',rundays=rundays,cncdays=cncdays)
allproc('NWR','A','100501','100531',rundays=rundays,cncdays=cncdays) # cal swap mid month
allproc('NWR','A','100601','100630',rundays=rundays,cncdays=cncdays)
allproc('NWR','A','100701','100731',rundays=rundays,cncdays=cncdays)
allproc('NWR','A','100801','100820',rundays=rundays,cncdays=cncdays) # Li820 source out on 21st
allproc('NWR','A','100907','100930',rundays=rundays,cncdays=cncdays) # new source on 7th
allproc('NWR','A','101001','101031',rundays=rundays,cncdays=cncdays)
allproc('NWR','A','101101','101130',rundays=rundays,cncdays=cncdays)
allproc('NWR','A','101201','101231',rundays=rundays,cncdays=cncdays)
allproc('NWR','A','110101','110131',rundays=rundays,cncdays=cncdays) # sample pump out for 2 weeks
allproc('NWR','A','110201','110228',rundays=rundays,cncdays=cncdays) # sample pump out for 2 more weeks
allproc('NWR','A','110301','110331',rundays=rundays,cncdays=cncdays)
allproc('NWR','A','110401','110430',rundays=rundays,cncdays=cncdays)
allproc('NWR','A','110501','110531',rundays=rundays,cncdays=cncdays,askup=F) # cal swap mid month

system('date',T)

allproc('FEF','C','050830','050831',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','050901','050930',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','051001','051009',rundays=rundays,runconc=F) # screen for power outage, flow drops, and instrument off
allproc('FEF','C','051010','051010',rundays=rundays,runconc=F,aeco=0.4)
allproc('FEF','C','051011','051013',rundays=rundays,runconc=F)
allproc('FEF','C','051014','051014',rundays=rundays,runconc=F,aeco=0.3)
allproc('FEF','C','051015','051015',rundays=rundays,runconc=F,aico=0.2)
allproc('FEF','C','051016','051018',rundays=rundays,runconc=F)
allproc('FEF','C','051019','051019',rundays=rundays,runconc=F,aeco=0.1)
allproc('FEF','C','051026','051031',rundays=rundays,runconc=F)
allproc('FEF','C','051001','051031',rundays=F,cncdays=cncdays)
allproc('FEF','C','051101','051117',rundays=rundays,runconc=F) # screen for flow drops and instrument off
allproc('FEF','C','051128','051128',rundays=rundays,runconc=F,aico=0.77)
allproc('FEF','C','051129','051130',rundays=rundays,runconc=F)
allproc('FEF','C','051101','051130',rundays=F,cncdays=cncdays)
allproc('FEF','C','051201','051231',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','060101','060131',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','060201','060228',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','060301','060331',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','060401','060430',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','060501','060531',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','060601','060630',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','060701','060720',rundays=rundays,cncdays=cncdays) # break for cylinder swap out (run as 1 w/ future code)
allproc('FEF','C','060721','060731',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','060801','060831',rundays=rundays,cncdays=cncdays) # need to screen for pump failure?
allproc('FEF','C','060901','060930',rundays=rundays,cncdays=cncdays) 
allproc('FEF','C','061001','061031',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','061101','061130',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','061201','061231',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','070101','070131',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','070201','070228',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','070301','070331',rundays=rundays,runconc=F) # break for cylinder swap out (run as 1 w/ future code)
allproc('FEF','C','070301','070321',rundays=F,cncdays=cncdays,aeco=0.8) 
allproc('FEF','C','070321','070331',rundays=F,cncdays=cncdays,aico=0.8)
allproc('FEF','C','070401','070430',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','070501','070531',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','070601','070630',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','070701','070731',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','070801','070831',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','070901','070930',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','071001','071031',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','071101','071130',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','071201','071231',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','080101','080131',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','080201','080229',rundays=rundays,runconc=F) # break for cylinder swap out (run as 1 w/ future code)
allproc('FEF','C','080201','080213',rundays=F,cncdays=cncdays,aeco=0.9) 
allproc('FEF','C','080213','080229',rundays=F,cncdays=cncdays,aico=0.9)
allproc('FEF','C','080301','080328',rundays=rundays,cncdays=cncdays) # apparent drive fill 28th - 2nd
allproc('FEF','C','080402','080411',rundays=rundays,cncdays=cncdays) # break for cylinder swap out (run as 1 w/ future code)
allproc('FEF','C','080429','080430',rundays=rundays,cncdays=cncdays) 
allproc('FEF','C','080501','080531',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','080601','080630',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','080701','080731',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','080801','080831',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','080901','080930',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','081001','081031',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','081101','081130',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','081201','081231',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','090101','090131',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','090201','090228',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','090301','090331',rundays=rundays,runconc=F) # cal gases ran out, 2nd on 26th
allproc('FEF','C','090301','090325',rundays=F,cncdays=cncdays)
# no data with cals in 0904
allproc('FEF','C','090509','090531',rundays=rundays,cncdays=cncdays) # new cal gases on 8th
allproc('FEF','C','090601','090630',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','090701','090731',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','090801','090831',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','090901','090930',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','091001','091031',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','091101','091130',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','091201','091231',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','100101','100131',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','100201','100228',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','100301','100331',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','100401','100430',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','100501','100531',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','100601','100630',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','100701','100731',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','100801','100831',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','100901','100930',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','101001','101031',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','101101','101111',rundays=rundays,cncdays=cncdays) # Li820 source out from 12th - 7th
allproc('FEF','C','101208','101231',rundays=rundays,cncdays=cncdays) # Li820 source out from 12th - 7th
allproc('FEF','C','110101','110131',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','110201','110228',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','110301','110331',rundays=rundays,cncdays=cncdays) # cal swap mid-month
allproc('FEF','C','110401','110430',rundays=rundays,cncdays=cncdays)
allproc('FEF','C','110501','110531',rundays=rundays,cncdays=cncdays,askup=F)

allproc('FEF','C','111101','111130',rundays=rundays,cncdays=cncdays)

system('date',T)

allproc('SPL','D','050902','050924',rundays=rundays,cncdays=cncdays) # break for nafion failure
allproc('SPL','D','050925','050930',rundays=rundays,cncdays=cncdays)
allproc('SPL','D','051001','051015',rundays=rundays,cncdays=cncdays) # break for nafion failure
allproc('SPL','D','051016','051031',rundays=rundays,cncdays=cncdays)
allproc('SPL','D','051101','051107',rundays=rundays,runconc=F) # screen for reset on 1108 
allproc('SPL','D','051108','051108',rundays=rundays,runconc=F,aeco=0.7)
allproc('SPL','D','051109','051130',rundays=rundays,runconc=F)
allproc('SPL','D','051101','051130',rundays=F,cncdays=cncdays)
allproc('SPL','D','051201','051231',rundays=rundays,cncdays=cncdays)
allproc('SPL','D','060101','060131',rundays=rundays,cncdays=cncdays)
allproc('SPL','D','060201','060201',rundays=rundays,runconc=F) # screen for Andy on 0202 
allproc('SPL','D','060202','060202',rundays=rundays,runconc=F,aeco=0.8)
allproc('SPL','D','060203','060228',rundays=rundays,runconc=F)
allproc('SPL','D','060201','060228',rundays=F,cncdays=cncdays)
allproc('SPL','D','060301','060331',rundays=rundays,cncdays=cncdays) # cylinder swap on 060303
allproc('SPL','D','060401','060430',rundays=rundays,cncdays=cncdays)
allproc('SPL','D','060501','060531',rundays=rundays,cncdays=cncdays)
allproc('SPL','D','060601','060630',rundays=rundays,cncdays=cncdays)
allproc('SPL','D','060701','060731',rundays=rundays,cncdays=cncdays)
allproc('SPL','D','060801','060831',rundays=rundays,cncdays=cncdays) # LT swapped on 18th
allproc('SPL','D','060901','060920',rundays=rundays,runconc=F,aeco=0.5) # break for Li-Cor retune, cuts immediately after cal
allproc('SPL','D','060921','060930',rundays=rundays,runconc=F,aico=0.15625) # cuts immediately before cal (get cal-step filter running in acconc)
allproc('SPL','D','060901','060930',rundays=F,cncdays=cncdays) 
allproc('SPL','D','061001','061031',rundays=rundays,cncdays=cncdays)
allproc('SPL','D','061101','061130',rundays=rundays,cncdays=cncdays)
allproc('SPL','D','061201','061231',rundays=rundays,cncdays=cncdays)
allproc('SPL','D','070101','070131',rundays=rundays,runconc=F) # break for cylinder swap out (run as 1 w/ future code)
allproc('SPL','D','070101','070112',rundays=F,cncdays=cncdays,aeco=0.5) 
allproc('SPL','D','070112','070131',rundays=F,cncdays=cncdays,aico=0.9)
allproc('SPL','D','070201','070228',rundays=rundays,cncdays=cncdays)
allproc('SPL','D','070301','070331',rundays=rundays,cncdays=cncdays)
allproc('SPL','D','070401','070430',rundays=rundays,cncdays=cncdays)
allproc('SPL','D','070501','070531',rundays=rundays,cncdays=cncdays)
allproc('SPL','D','070601','070622',rundays=rundays,runconc=F,aeco=0.83333) # break for Li-Cor step change, cuts immediately after cal
allproc('SPL','D','070623','070630',rundays=rundays,runconc=F,aico=0.15625) # cuts immediately before cal (get cal-step filter running in acconc)
allproc('SPL','D','070601','070630',rundays=F,cncdays=cncdays) 
allproc('SPL','D','070701','070731',rundays=rundays,cncdays=cncdays)
allproc('SPL','D','070801','070828',rundays=rundays,runconc=F,aeco=0.5) # break for Li-Cor step change, cuts immediately after cal
allproc('SPL','D','070830','070831',rundays=rundays,runconc=F,aico=0.15625) # cuts immediately before cal (get cal-step filter running in acconc)
allproc('SPL','D','070801','070831',rundays=F,cncdays=cncdays) 
allproc('SPL','D','070901','070930',rundays=rundays,cncdays=cncdays)
# no data for 0710 or 0711
allproc('SPL','D','071207','071231',rundays=rundays,cncdays=cncdays) # no data before 6th
# allproc('SPL','D','080101','080101',rundays=rundays,cncdays=cncdays,aeco=0.6,atc=F,apc=F)
allproc('SPL','D','080101','080101',rundays=rundays,runconc=F) # (only a few hours while Li820 failing) break for Li820 failure and cylinder swap out
allproc('SPL','D','080127','080131',rundays=rundays,cncdays=cncdays,aico=0.2,asflc=-100) # remove sample flow cutoff
allproc('SPL','D','080201','080229',rundays=rundays,cncdays=cncdays)
allproc('SPL','D','080301','080328',rundays=rundays,cncdays=cncdays) # apparent drive fill 28th - 2nd
allproc('SPL','D','080402','080430',rundays=rundays,cncdays=cncdays)
allproc('SPL','D','080502','080531',rundays=rundays,cncdays=cncdays)
allproc('SPL','D','080601','080630',rundays=rundays,cncdays=cncdays)
allproc('SPL','D','080701','080731',rundays=rundays,cncdays=cncdays)
allproc('SPL','D','080801','080831',rundays=rundays,cncdays=cncdays)
allproc('SPL','D','080901','080930',rundays=rundays,cncdays=cncdays)
allproc('SPL','D','081127','081130',rundays=rundays,cncdays=cncdays) # pump fixed (?)
allproc('SPL','D','081201','081231',rundays=rundays,cncdays=cncdays)
allproc('SPL','D','090101','090131',rundays=rundays,cncdays=cncdays)
allproc('SPL','D','090201','090228',rundays=rundays,cncdays=cncdays)
allproc('SPL','D','090301','090331',rundays=rundays,runconc=F) # cal gases running out - LS1 drift starts on 12th
allproc('SPL','D','090301','090311',rundays=F,cncdays=cncdays)
allproc('SPL','D','090401','090430',rundays=rundays,runconc=F) # break for cylinder swap out (run as 1 w/ future code)
allproc('SPL','D','090407','090430',rundays=F,cncdays=cncdays) # no cal gases until end of 090405, last one up at end of 090406
allproc('SPL','D','090501','090531',rundays=rundays,cncdays=cncdays)
allproc('SPL','D','090601','090630',rundays=rundays,cncdays=cncdays) 
allproc('SPL','D','090701','090731',rundays=rundays,cncdays=cncdays)
allproc('SPL','D','090801','090831',rundays=rundays,cncdays=cncdays)
allproc('SPL','D','090901','090920',rundays=rundays,cncdays=cncdays) # Li820 failed on 21st
# no data 0910-1001
allproc('SPL','D','100203','100222',rundays=rundays,cncdays=cncdays,asflc=-100) # sample mfm bad, also leak - exclude all?
allproc('SPL','D','100325','100331',rundays=rundays,cncdays=cncdays) # leak fixed on 24th
allproc('SPL','D','100401','100430',rundays=rundays,cncdays=cncdays)
allproc('SPL','D','100501','100531',rundays=rundays,cncdays=cncdays)
allproc('SPL','D','100601','100630',rundays=rundays,cncdays=cncdays) # cal swap mid-month
allproc('SPL','D','100701','100731',rundays=rundays,cncdays=cncdays) # HS2 turned off on 6th (was leaking)
allproc('SPL','D','100801','100831',rundays=rundays,cncdays=cncdays) # no HS2
allproc('SPL','D','100901','100930',rundays=rundays,cncdays=cncdays) # no HS2
#allproc('SPL','D','101001','101031',rundays=rundays,cncdays=cncdays) # HS2 turned on on 22nd, signals all jumped - 3 pt cals for first 2/3 of month using bad ave curvature
allproc('SPL','D','101001','101021',rundays=rundays,cncdays=cncdays,aeco=0.833) # see above
allproc('SPL','D','101022','101031',rundays=rundays,cncdays=cncdays) # see above
allproc('SPL','D','101101','101130',rundays=rundays,cncdays=cncdays)
allproc('SPL','D','101201','101231',rundays=rundays,cncdays=cncdays)
allproc('SPL','D','110101','110131',rundays=rundays,cncdays=cncdays)
allproc('SPL','D','110201','110228',rundays=rundays,cncdays=cncdays)
allproc('SPL','D','110301','110331',rundays=rundays,cncdays=cncdays)
allproc('SPL','D','110401','110430',rundays=rundays,cncdays=cncdays) ### HS2 ran out, then cal swap - need special processing?
allproc('SPL','D','110501','110531',rundays=rundays,cncdays=cncdays,askup=F)


system('date',T)

allproc('HDP','E','060421','060430',rundays=rundays,cncdays=cncdays)
allproc('HDP','E','060501','060531',rundays=rundays,cncdays=cncdays)
allproc('HDP','E','060601','060630',rundays=rundays,cncdays=cncdays)
allproc('HDP','E','060701','060731',rundays=rundays,cncdays=cncdays) # asflco set to 70 in aircoa_conc_days.r
allproc('HDP','E','060801','060831',rundays=rundays,cncdays=cncdays)
allproc('HDP','E','060901','060930',rundays=rundays,cncdays=cncdays) 
allproc('HDP','E','061001','061011',rundays=rundays,cncdays=cncdays,aeco=0.7) # split for leak fix and recal
allproc('HDP','E','061012','061031',rundays=rundays,cncdays=cncdays)
allproc('HDP','E','061101','061130',rundays=rundays,cncdays=cncdays)
allproc('HDP','E','061201','061231',rundays=rundays,cncdays=cncdays)
allproc('HDP','E','070101','070131',rundays=rundays,cncdays=cncdays)
allproc('HDP','E','070201','070228',rundays=rundays,cncdays=cncdays)
allproc('HDP','E','070301','070331',rundays=rundays,runconc=F) # break for cylinder swap out (run as 1 w/ future code)
allproc('HDP','E','070301','070307',rundays=F,cncdays=cncdays,aeco=0.7) 
allproc('HDP','E','070307','070331',rundays=F,cncdays=cncdays,aico=0.7)
allproc('HDP','E','070401','070430',rundays=rundays,cncdays=cncdays)
allproc('HDP','E','070501','070531',rundays=rundays,cncdays=cncdays)
allproc('HDP','E','070601','070630',rundays=rundays,cncdays=cncdays)
allproc('HDP','E','070701','070731',rundays=rundays,cncdays=cncdays)
allproc('HDP','E','070801','070831',rundays=rundays,cncdays=cncdays)
allproc('HDP','E','070901','070930',rundays=rundays,cncdays=cncdays)
allproc('HDP','E','071001','071031',rundays=rundays,cncdays=cncdays) # on 27th one bad HS2 that affects LT (get cal-step filter working in acconc)
allproc('HDP','E','071101','071130',rundays=rundays,cncdays=cncdays) # on 7th and 11th one bad HS2 that affects LT (get cal-step filter working in acconc)
allproc('HDP','E','071201','071231',rundays=rundays,cncdays=cncdays) # one bad LT on 27th, unclear cause
allproc('HDP','E','080101','080124',rundays=rundays,cncdays=cncdays) # cal gases out on 24th in on 25th
allproc('HDP','E','080225','080229',rundays=rundays,cncdays=cncdays) 
allproc('HDP','E','080301','080331',rundays=rundays,cncdays=cncdays) 
allproc('HDP','E','080401','080430',rundays=rundays,cncdays=cncdays) 
allproc('HDP','E','080501','080531',rundays=rundays,cncdays=cncdays) 
allproc('HDP','E','080601','080630',rundays=rundays,cncdays=cncdays)
allproc('HDP','E','080701','080731',rundays=rundays,cncdays=cncdays)
allproc('HDP','E','080801','080831',rundays=rundays,cncdays=cncdays)
allproc('HDP','E','080901','080901',rundays=rundays,cncdays=cncdays,aeco=0.18) # could just delete this but running now to get rid of old with bad data at end
# no data 0809 - 0904
allproc('HDP','E','090509','090518',rundays=rundays,runconc=F,aeco=0.65) # stop just before CO2 probs started
allproc('HDP','E','090519','090531',rundays=rundays,runconc=F,askp=125) # use last 25 seconds only

allproc('HDP','E','090514','090531',rundays=F,cncdays=cncdays,aico=0.8,ahdp=T) # back up on 9th, but flow not fixed until 0.8 on 14th
allproc('HDP','E','090601','090630',rundays=rundays,cncdays=cncdays,askp=125,ahdp=T) # use last 25 seconds only
allproc('HDP','E','090701','090731',rundays=rundays,cncdays=cncdays,askp=125,ahdp=T) # use last 25 seconds only
allproc('HDP','E','090801','090821',rundays=rundays,cncdays=cncdays,askp=125,ahdp=T) # was using last 50 seconds - diff? # comms out and memory stick full
allproc('HDP','E','090917','090919',rundays=rundays,cncdays=cncdays,askp=125) # was using last 75 seconds - diff? # cal gases ran out # turn hdpfix on?

# no data 0910
allproc('HDP','E','091112','091130',rundays=rundays,cncdays=cncdays) # turn hdpfix on?
allproc('HDP','E','091201','091231',rundays=rundays,cncdays=cncdays) # turn hdpfix on?
allproc('HDP','E','100101','100131',rundays=rundays,cncdays=cncdays) # turn hdpfix on?
allproc('HDP','E','100201','100228',rundays=rundays,cncdays=cncdays) # turn hdpfix on?
allproc('HDP','E','100301','100331',rundays=rundays,cncdays=cncdays) # turn hdpfix on?
allproc('HDP','E','100401','100430',rundays=rundays,cncdays=cncdays) # turn hdpfix on?
allproc('HDP','E','100501','100531',rundays=rundays,cncdays=cncdays) # turn hdpfix on?
allproc('HDP','E','100601','100630',rundays=rundays,cncdays=cncdays) # turn hdpfix on?
allproc('HDP','E','100701','100731',rundays=rundays,cncdays=cncdays) # turn hdpfix on?
allproc('HDP','E','100801','100831',rundays=rundays,cncdays=cncdays) # turn hdpfix on?
allproc('HDP','E','100901','100904',rundays=rundays,cncdays=cncdays) # cal gases ran out # turn hdpfix on?
# no data 1010
allproc('HDP','E','101119','101130',rundays=rundays,cncdays=cncdays) # turn hdpfix on?
allproc('HDP','E','101201','101231',rundays=rundays,cncdays=cncdays) # turn hdpfix on?
allproc('HDP','E','110101','110131',rundays=rundays,cncdays=cncdays) # turn hdpfix on?
allproc('HDP','E','110201','110228',rundays=rundays,cncdays=cncdays) # turn hdpfix on?
allproc('HDP','E','110301','110331',rundays=rundays,cncdays=cncdays) # turn hdpfix on?
allproc('HDP','E','110401','110430',rundays=rundays,cncdays=cncdays) # turn hdpfix on?
allproc('HDP','E','110501','110531',rundays=rundays,cncdays=cncdays,askup=F) # turn hdpfix on?

system('date',T)

allproc('EFS','G','070820','070831',rundays=rundays,cncdays=cncdays,askp=125,atrh='custom') # use last 25 seconds only
allproc('EFS','G','070901','070930',rundays=rundays,cncdays=cncdays,askp=125,atrh='custom')
allproc('EFS','G','071001','071031',rundays=rundays,cncdays=cncdays,askp=125,atrh='custom')
allproc('EFS','G','071101','071130',rundays=rundays,cncdays=cncdays,askp=125,atrh='custom')
allproc('EFS','G','071201','071231',rundays=rundays,cncdays=cncdays,askp=125,atrh='custom')
allproc('EFS','G','080101','080131',rundays=rundays,cncdays=cncdays,askp=125,atrh='custom')
allproc('EFS','G','080201','080229',rundays=rundays,cncdays=cncdays,askp=125,atrh='custom')
allproc('EFS','G','080301','080331',rundays=rundays,cncdays=cncdays,askp=125,atrh='custom',asflc=10) # leak in Nafion #1 caused low sample flow reading
allproc('EFS','G','080401','080430',rundays=rundays,cncdays=cncdays,askp=125,atrh='custom',asflc=10) 
allproc('EFS','G','080501','080531',rundays=rundays,cncdays=cncdays,askp=125,atrh='custom',asflc=10)
allproc('EFS','G','080601','080630',rundays=rundays,cncdays=cncdays,askp=125,atrh='custom',asflc=10)
allproc('EFS','G','080701','080731',rundays=rundays,cncdays=cncdays,askp=125,atrh='custom',asflc=10)
allproc('EFS','G','080801','080831',rundays=rundays,cncdays=cncdays,askp=125,atrh='custom',asflc=10)
allproc('EFS','G','080901','080912',rundays=rundays,runconc=F,askp=125,atrh='custom') # break for flowmeter change, li820 cal, line 2 and 3 moves, and Nafion leak fix
allproc('EFS','G','080901','080911',rundays=F,cncdays=cncdays,asflc=10)
allproc('EFS','G','080913','080930',rundays=rundays,runconc=F,atrh='custom') 
allproc('EFS','G','080913','080930',rundays=F,cncdays=cncdays)
allproc('EFS','G','081001','081031',rundays=rundays,cncdays=cncdays,atrh='custom')
allproc('EFS','G','081101','081130',rundays=rundays,cncdays=cncdays,atrh='custom')
allproc('EFS','G','081201','081231',rundays=rundays,cncdays=cncdays,atrh='custom')
allproc('EFS','G','090101','090131',rundays=rundays,cncdays=cncdays,atrh='custom')
allproc('EFS','G','090201','090228',rundays=rundays,cncdays=cncdays,atrh='custom')
allproc('EFS','G','090301','090331',rundays=rundays,cncdays=cncdays,atrh='custom')
allproc('EFS','G','090401','090430',rundays=rundays,cncdays=cncdays,atrh='custom',askup=F) 
# micropump failed on 090429, stopped on 090511
# removed instrument in 2010

system('date',T)

allproc('RBA','I','071023','071031',rundays=rundays,cncdays=cncdays)
allproc('RBA','I','071101','071130',rundays=rundays,cncdays=cncdays)
# no data 0712 - 0805
allproc('RBA','I','080520','080531',rundays=rundays,cncdays=cncdays)
allproc('RBA','I','080601','080630',rundays=rundays,cncdays=cncdays)
# no data 0807 - 0910
allproc('RBA','I','091119','091130',rundays=rundays,cncdays=cncdays)
allproc('RBA','I','091201','091231',rundays=rundays,cncdays=cncdays)
allproc('RBA','I','100101','100131',rundays=rundays,cncdays=cncdays)
allproc('RBA','I','100201','100228',rundays=rundays,cncdays=cncdays)
allproc('RBA','I','100301','100305',rundays=rundays,cncdays=cncdays)
# no data 1004
allproc('RBA','I','100529','100531',rundays=rundays,cncdays=cncdays)
allproc('RBA','I','100601','100630',rundays=rundays,cncdays=cncdays)
allproc('RBA','I','100701','100731',rundays=rundays,cncdays=cncdays)
allproc('RBA','I','100801','100831',rundays=rundays,cncdays=cncdays)
allproc('RBA','I','100901','100930',rundays=rundays,cncdays=cncdays)
allproc('RBA','I','101001','101031',rundays=rundays,cncdays=cncdays)
allproc('RBA','I','101101','101130',rundays=rundays,cncdays=cncdays) # no data 13th-23rd, cylinder swap out on 24th
allproc('RBA','I','101201','101231',rundays=rundays,cncdays=cncdays)
allproc('RBA','I','110101','110131',rundays=rundays,cncdays=cncdays)
allproc('RBA','I','110201','110228',rundays=rundays,cncdays=cncdays)
allproc('RBA','I','110301','110331',rundays=rundays,cncdays=cncdays) # several weeks of missing data
allproc('RBA','I','110401','110430',rundays=rundays,cncdays=cncdays) ### need to run 110405 on
# had to delete last incomplete line of ai_110405_160001.dat - complete file on aircoa?
allproc('RBA','I','110501','110531',rundays=rundays,cncdays=cncdays) # HS2 out, then cal swap - require special processing?
allproc('RBA','I','110601','110630',rundays=rundays,cncdays=cncdays)
allproc('RBA','I','110701','110731',rundays=rundays,cncdays=cncdays)
allproc('RBA','I','110801','110831',rundays=rundays,cncdays=cncdays)
allproc('RBA','I','110901','110930',rundays=rundays,cncdays=cncdays)
allproc('RBA','I','111001','111031',rundays=rundays,cncdays=cncdays)
allproc('RBA','I','111101','111130',rundays=rundays,cncdays=cncdays) 
allproc('RBA','I','111201','111231',rundays=rundays,cncdays=cncdays)
allproc('RBA','I','120101','120131',rundays=rundays,cncdays=cncdays)
allproc('RBA','I','120201','120229',rundays=rundays,cncdays=cncdays)
allproc('RBA','I','120301','120314',rundays=rundays,cncdays=cncdays) # no data after 14th
allproc('RBA','I','120416','120420',rundays=rundays,cncdays=cncdays) # only 3 full days of data (16-20)
#allproc('RBA','I','120501','120531',rundays=rundays,cncdays=cncdays) # no data
#allproc('RBA','I','120601','120630',rundays=rundays,cncdays=cncdays) # no data
#allproc('RBA','I','120701','120731',rundays=rundays,cncdays=cncdays) # no data
allproc('RBA','I','120808','120831',rundays=rundays,cncdays=cncdays) # data starts back up on 8th
allproc('RBA','I','120901','120930',rundays=rundays,cncdays=cncdays)
allproc('RBA','I','121001','121031',rundays=rundays,cncdays=cncdays)
allproc('RBA','I','121101','121108',rundays=rundays,cncdays=cncdays) 
#allproc('RBA','I','121101','121130',rundays=rundays,cncdays=cncdays) 
#allproc('RBA','I','121201','121231',rundays=rundays,cncdays=cncdays,askup=F)

system('date',T)


# to compare multiple sites

# run comp for 2 units in 0508
accomp('050826','050831',locs=c('NWR','FEF'))
acmkhtml('','','050826','050831',F,F,T)

## 3 units 0509-0603
## 4 units 0604-0707
## 5 units 0708-0709
## 4-6 units 0710-0805

# run comp for 3-6 units 0509-1102

dayblank<-substr(as.character(c(10509:10512,10601:10612,10701:10712,10801:10812,10901:10912,11001:11012,11101:11102)),2,5)
for(mon in dayblank){
	day0<-paste(mon,'01',sep='')
	if(any(c('01','03','05','07','08','10','12')==substr(mon,3,4))){
		day<-paste(mon,'31',sep='')
	}
	if(any(c('04','06','09','11')==substr(mon,3,4))){
		day<-paste(mon,'30',sep='')
	}
	if('02'==substr(mon,3,4)){
		if(as.numeric(substr(mon,1,2))/4-trunc(as.numeric(substr(mon,1,2))/4)==0){
			day<-paste(mon,'29',sep='')
		}else{
			day<-paste(mon,'28',sep='')
		}
	}
	accomp(day0,day,locs=c('NWR','FEF','SPL','HDP','EFS','RBA'))
	acmkhtml('','',day0,day,F,F,T)
}

system('date',T)

# to compare to flask data at NWR
source('../../nwr_icp.r')

# plot all LTs
source('../../aircoa_all_lt.r')
