options(echo=FALSE) # turn off command line output

# point to directory containing daily output files
rawdatadir<-'/scr/raf/stephens/RCDAT'

# read in programs
source('../../aircoa_raw_day.r') # acrawday(loc='NWR',unit='A',day='050901',outflag='',njog=150,skip=50,ico=0.0,eco=1.0,trh='humitter',png=F,datadir='/scr/raf2/stephens/RCDAT',preserve=F)
source('../../aircoa_make_html.r') # acmkhtml(loc='NWR',unit='A',start='050901',end='050907',procday=T,procconc=F,proccomp=F,outflag='',netdir='/net/www/docs/homes/stephens/RACCOON/',remold=T,remall=F)
source('../../aircoa_conc_days.r') # accncdys(loc='NWR',unit='A',startchr='050901',endchr='050907',inflag='',outflag='',pcor=T,tcor=T,fcor=F,ltmpco=0.5,sflco=70,ico=0.0,eco=1.0,png=F,daily=T,nlines=3)
source('../../aircoa_comp.r') # accomp(start='080101',end='080131',locs=c('NWR','FEF','SPL','HDP','EFS','RBA'),outflag='',ico=0.0,eco=1.0,png=F,nlines=c(3,3,3,3,3,3))

# set up daily autorun procedure
arun<-function(unit='A',loc='NWR',day='051111',day0='051101',conc=T,concforce=F,anjog=150,askp=50,atrh='humitter',aico=0.0,aeco=1.0,asflco=70){
newdatathissite<-F
for(i in c(as.numeric(day0):as.numeric(day))){ 
#print(c(unit,i))
	# check for incomplete daily runs - looking for more recent *.dat than *.out
	# this requires that rsync be run without option -t (times will be that of transfer) and with option -u (skips updating files with different
	#   dates if server date is newer) or --size-only (only transfers if sizes are different)
	itxt<-as.character(i)
	month<-substr(itxt,1,4)
	#### in mid-Apr 2012, second T started causing nothing to be returned, and setting ignore.stderr=T does not suppress warnings
	#rawfiles<-system(paste('ls -rt ',rawdatadir,'/a',tolower(chartr('ABCDEFG','1234567',unit)),'*',itxt,'*.dat',sep=''),T,T) 
	#rawfiles<-system(paste('ls -rt ',rawdatadir,'/a',tolower(chartr('ABCDEFG','1234567',unit)),'*',itxt,'*.dat',sep=''),T)
	rawfiles<-list.files(rawdatadir,glob2rx(paste('a',tolower(chartr('ABCDEFG','1234567',unit)),'*',itxt,'*.dat',sep='')))
	if(length(rawfiles)>0){
		lastfile<-rawfiles[length(rawfiles)]
		#rawdate<-system(paste('date +%y%m%d%H%M%S -r ',lastfile,sep=''),T,T) # date of last file of day
		#rawdate<-system(paste('date +%y%m%d%H%M%S -r ',lastfile,sep=''),T) # date of last file of day
		rawdate<-strftime(file.info(paste(rawdatadir,'/',lastfile,sep=''))$mtime,format='%y%m%d%H%M%S') # date of last file of day
	} else {
		rawdate=0
	}
	#zipfiles<-system(paste('ls -rt ',rawdatadir,'/a',tolower(chartr('ABCDEFG','1234567',unit)),'*',itxt,'*.dat.gz',sep=''),T,T)
	#zipfiles<-system(paste('ls -rt ',rawdatadir,'/a',tolower(chartr('ABCDEFG','1234567',unit)),'*',itxt,'*.dat.gz',sep=''),T)
	zipfiles<-list.files(rawdatadir,glob2rx(paste('a',tolower(chartr('ABCDEFG','1234567',unit)),'*',itxt,'*.dat.gz',sep='')))
	if(length(zipfiles)>0){
		lastfile<-zipfiles[length(zipfiles)]
		#zipdate<-system(paste('date +%y%m%d%H%M%S -r ',lastfile,sep=''),T,T) # date of last zip file of day 
		#zipdate<-system(paste('date +%y%m%d%H%M%S -r ',lastfile,sep=''),T) # date of last zip file of day
		zipdate<-strftime(file.info(paste(rawdatadir,'/',lastfile,sep=''))$mtime,format='%y%m%d%H%M%S') # date of last file of day
	} else {
		zipdate=0
	}
	#daydate<-system(paste('date +%y%m%d%H%M%S -r ',month,'/',loc,'/',loc,'_',itxt,'.out',sep=''),T,T) 
#	daydate<-system(paste('date +%y%m%d%H%M%S -r ',month,'/',loc,'/',loc,'_',itxt,'.out',sep=''),T)
	daydate<-strftime(file.info(paste(month,'/',loc,'/',loc,'_',itxt,'.out',sep=''))$mtime,format='%y%m%d%H%M%S') # date of last output file
	if(is.na(daydate)){daydate=0}
	if(length(daydate)==0){daydate<-0}
#### problem if site has both zipped and unzipped data for same day, only unzipped data gets run
	if(length(rawfiles)>0){ # unzipped files for this day exist
		if(rawdate>daydate){
			newdatathissite<-T
			acrawday(loc,unit,itxt,'',anjog,askp,trh=atrh)
			acmkhtml(loc,unit,'',itxt)
		}
	} else if(length(zipfiles)>0){ # zipped files for this day exist
		if(zipdate>daydate){
			newdatathissite<-T
			acrawday(loc,unit,itxt,'',anjog,askp,trh=atrh)
			acmkhtml(loc,unit,'',itxt)
		}
	}
}
if(concforce|(conc&newdatathissite)){ # run concentration processing program
	accncdys(loc,unit,day0,day,ico=aico,eco=aeco,sflco=asflco,skipupdate=F)
	checkrun<-system(paste('ls ',month,'/',loc,'/',loc,'_',day0,'_',day,'.mes',sep=''),T)
	if(length(checkrun)>0){ # aircoa_conc_days actually ran
		acmkhtml(loc,unit,day0,day,F,T)
	}
}
newdatathissite<<-newdatathissite
if(newdatathissite){newdataanysite<<-T}
print(paste('newdatathissite = ',newdatathissite))
}

# find date for today and first of month
day<-system('date +%y%m%d',T)
day0<-paste(substr(day,1,4),'01',sep='')

# run all sites
newdataanysite<<-F

arun('C','FEF',day=day,day0=day0)
arun('A','NWR',day=day,day0=day0)
#arun('D','SPL',day=day,day0=day0)
arun('G','SPL',day=day,day0=day0,atrh='custom')
arun('I','RBA',day=day,day0=day0)
arun('E','HDP',day=day,day0=day0) ### putting HDP last b/c occasionally ends with half a line and a - sign which crashes
#if(day0=='100901'){ arun('D','SPL',day=day,day0=day0,conc=F) } else { arun('D','SPL',day=day,day0=day0) }
#arun('G','EFS',day=day,day0=day0,atrh='custom')

print(paste('newdataanysite = ',newdataanysite))

# compare multiple sites
if(newdataanysite){
#accomp(day0,day,locs=c('NWR','FEF','SPL','HDP','EFS','RBA'),nlines=c(3,3,3,3,3,3))
accomp(day0,day,locs=c('NWR','FEF','SPL','HDP','RBA'),nlines=c(3,3,3,3,3))
#accomp(day0,day,locs=c('NWR','FEF','SPL','HDP','EFS'),nlines=c(3,3,3,3,3))
acmkhtml('','',day0,day,F,F,T)
}

# check previous month to look for any days still needing processing
year<-system('date +%y',T)
nyr<-as.numeric(year)
mon<-system('date +%m',T)
nmon<-as.numeric(mon)-1
if(nmon==0){
        nmon<-12
        nyr<-nyr-1
}
prev<-paste(substr(as.character(nyr+100),2,3),substr(as.character(nmon+100),2,3),sep='') # eg '0705'
monthdays<-c(31,28,31,30,31,30,31,31,30,31,30,31)
if(nyr/4-trunc(nyr/4)==0){ # leap year
	monthdays[2]<-29
}
mdays<-monthdays[nmon]
day<-paste(prev,mdays,sep='')
day0<-paste(prev,'01',sep='')
newdataanysite<<-F
arun('C','FEF',day=day,day0=day0)
arun('A','NWR',day=day,day0=day0)
#arun('D','SPL',day=day,day0=day0)
arun('G','SPL',day=day,day0=day0,atrh='custom')
arun('I','RBA',day=day,day0=day0)
arun('E','HDP',day=day,day0=day0) ### putting HDP last b/c occasionally ends with half a line and a - sign which crashes
#if(day0=='100901'){ arun('D','SPL',day=day,day0=day0,conc=F) } else { arun('D','SPL',day=day,day0=day0) }
#arun('G','EFS',day=day,day0=day0,atrh='custom')
##arun('G','EFS',day=day,day0=day0,askp=125,atrh='custom',asflco=10)

# rerun comp for previous month if needed
print(paste('newdataanysite = ',newdataanysite))
if(newdataanysite){
	#accomp(day0,day,locs=c('NWR','FEF','SPL','HDP','EFS','RBA'),nlines=c(3,3,3,3,3,3))
	accomp(day0,day,locs=c('NWR','FEF','SPL','HDP','RBA'),nlines=c(3,3,3,3,3,3))
#	accomp(day0,day,locs=c('NWR','FEF','SPL','HDP','EFS'),nlines=c(3,3,3,3,3))
	acmkhtml('','',day0,day,F,F,T)
}

# compare AIRCOA to flask data at NWR
source('../../nwr_icp.r')

## to manually skip the start of a month:
#if(substr(day,1,4)=='0802'){ 
#	day0<-'080213' 
#	arun('C','FEF',day=day,day0=day0,aico=0.9)
#	day0<-paste(substr(day,1,4),'01',sep='') # resetting to first day of month
#} else {
#}

## to manually skip end of a month:
#if(substr(day,1,4)=='0801'){ day<-'080101' } 
#day<-system('date +%y%m%d',T) # resetting to current day
#arun('E','HDP',day=day,day0=day0)
#} else {
#}
