//
//              Copyright 2004 (C) by UCAR
//

#include <atdUtil/UTime.h>
#include <cassert>

using namespace atdUtil;
using namespace std;


int main(int argc, char** argv)
{
    UTime tnow;

    string snow = tnow.format(false);
    cerr << "now=" << snow << endl;

    UTime::setDefaultFormat("%Y %b %d %H:%M:%S.%6f %Z");
    snow = tnow.format(false);
    cerr << "now=" << snow << endl;

    UTime::setDefaultFormat("%Y %b %d %H:%M:%S.%1f %Z");
    snow = tnow.format(true);
    cerr << "now=" << snow << endl;

    struct tm tm;
    int usecs;
    struct tm* tmp;
    
    tmp = tnow.toTm(false,&tm,&usecs);
    cerr << tmp->tm_year << ' ' << tmp->tm_mon << ' ' << tmp->tm_mday <<
	' ' << tmp->tm_yday <<
    	' ' << tmp->tm_hour << ' ' << tmp->tm_min << ' ' << tmp->tm_sec <<
	' ' << usecs << endl;
    UTime ut1(false,tmp->tm_year+1900,tmp->tm_mon+1,tmp->tm_mday,
    	tmp->tm_hour,tmp->tm_min,tmp->tm_sec,usecs);
    assert(ut1 == tnow);

    tmp = tnow.toTm(true,&tm,&usecs);
    cerr << tmp->tm_year << ' ' << tmp->tm_mon << ' ' << tmp->tm_mday <<
	' ' << tmp->tm_yday <<
    	' ' << tmp->tm_hour << ' ' << tmp->tm_min << ' ' << tmp->tm_sec <<
	' ' << usecs << endl;
    UTime ut2(true,tmp->tm_year+1900,tmp->tm_mon+1,tmp->tm_mday,
    	tmp->tm_hour,tmp->tm_min,tmp->tm_sec,usecs);
    assert(ut2 == tnow);

    UTime ut3(true,tmp->tm_year+1900,tmp->tm_yday + 1,
    	tmp->tm_hour,tmp->tm_min,tmp->tm_sec,usecs);
    cerr << "ut3-tnow=" << ut3 - tnow << endl;
    assert(ut3 == tnow);

    snow = ut3.format(false,"%Y %b %d %H:%M:%S.%6f");

    UTime ut4 = UTime::parse(false,snow,"%Y %b %d %H:%M:%S.%6f");
    snow = ut4.format(false,"%Y %b %d %H:%M:%S.%6f");
    cerr << "parsed ut4=" << snow << endl;
    assert(ut4 == tnow);

    UTime::setDefaultFormat("%Y %b %d %H:%M:%S.%6f %Z");
    snow = (ut4 + 1).format(false);
    cerr << "now+1=" << snow << endl;
    assert(ut4 + 1 > tnow);


    return 0;
}

