#include <atdUtil/Thread.h>
#include <iostream>
#include <sstream>
#include <vector>

#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <time.h>

using namespace std;

class Thread1: public atdUtil::Thread
{
public:
    Thread1(const string& name,int n): atdUtil::Thread(name),nloop(n) {}

    int run() throw(atdUtil::Exception)
    {
	std::cerr << getFullName() << " run starting" << std::endl;
	int nkill = (int)(double(random()) * nloop / RAND_MAX);
	cerr << "thread pid=" << getpid() << " nkill=" << nkill << endl;
	struct timespec ts;
	ts.tv_sec = 0;
	ts.tv_nsec = 1000000;
	int i;
	for (i = 0; i < nloop; i++) {
	    // std::cerr << getName() << " checking amInterrupted, i=" << i << std::endl;
	    if (amInterrupted()) break;
	    // std::cerr << getName() << " sleeping, i=" << i << std::endl;
	    nanosleep(&ts,0);
	    if (i == nkill) break;
	}
	// ::kill(getpid(),SIGUSR1);
	::kill(0,SIGUSR1);
	std::cerr << getFullName() << " run finished" << std::endl;
	return i;
    }

    int nloop;
};

        


void sigAction(int sig, siginfo_t* siginfo, void* vptr) {
    cerr << "received signal " <<  strsignal(sig) << '(' << sig << ')' <<
	" si_signo=" << (siginfo ? siginfo->si_signo : -1) <<
	" si_errno=" << (siginfo ? siginfo->si_errno : -1) <<
	" si_code= " << (siginfo ? siginfo->si_code : -1) << endl;
                                                                                
    switch(sig) {
    case SIGHUP:
    case SIGTERM:
    case SIGINT:
    case SIGUSR1:
        cerr << "pid==" << (siginfo ? siginfo->si_pid : -1) << endl;
        break;
    }
}
int main(int argc, char** argv)
{
    sigset_t sigset;
    sigemptyset(&sigset);
    sigaddset(&sigset,SIGHUP);
    sigaddset(&sigset,SIGTERM);
    sigaddset(&sigset,SIGINT);
    sigaddset(&sigset,SIGUSR1);
    sigprocmask(SIG_UNBLOCK,&sigset,(sigset_t*)0);
                                                                                
    struct sigaction act;
    sigemptyset(&sigset);
    act.sa_mask = sigset;
    act.sa_flags = SA_SIGINFO;
    act.sa_sigaction = sigAction;
    sigaction(SIGHUP,&act,(struct sigaction *)0);
    sigaction(SIGINT,&act,(struct sigaction *)0);
    sigaction(SIGTERM,&act,(struct sigaction *)0);
    sigaction(SIGUSR1,&act,(struct sigaction *)0);

    cerr << "main pid=" << getpid() << endl;

    vector<atdUtil::Thread*> threads;
    for (int i = 0; i < 10; i++) {
	ostringstream ost;
	ost << "Thread" << i;
	atdUtil::Thread* t1 = new Thread1(ost.str(),100);
	t1->blockSignal(SIGHUP);
	t1->blockSignal(SIGUSR1);
	t1->start();
	threads.push_back(t1);
    }

    struct timespec sleepTime;
    sleepTime.tv_sec = 20;
    sleepTime.tv_nsec = 0;
    while (threads.size() > 0) {
	cerr << "threads.size=" << threads.size() << endl;
	// pause();
	nanosleep(&sleepTime,0);

	vector<atdUtil::Thread*>::iterator ti;
	for (ti = threads.begin(); ti != threads.end(); ) {
	    atdUtil::Thread* t = *ti;
	    if (!t->isRunning()) {
		t->join();
		delete t;
		ti = threads.erase(ti);
	    }
	    else ++ti;
	}
    }
}
