//
//              Copyright 2004 (C) by UCAR
//

#include <iostream>
#include <sstream>
#include <unistd.h>
#include <time.h>
#include <assert.h>

#include <atdUtil/Socket.h>
#include <atdUtil/UnixSocketAddress.h>
#include <atdUtil/McSocket.h>
#include <atdUtil/Thread.h>

#include <vector>

using namespace atdUtil;
using namespace std;


static char* argvhost = "localhost";

class Reader: public Thread
{
public:
    Reader(const string& name,Socket* s) : Thread(name),sock(s)
    {
    }

    ~Reader() {
    }

    int run() throw(atdUtil::Exception)
    {
	cerr << "Reader::run, local=" << sock->getLocalSocketAddress().toString() <<
		" remote=" << sock->getRemoteSocketAddress().toString() << endl;
	char buf[512];
	const char* eob = buf + sizeof(buf);
	char* bp = buf;
	const char* eod;
	const char* cp;
	for (;;) {
	    int l;
	    try {
		l = sock->recv(bp,eob-bp,0);
	    }
	    catch(const EOFException& e) {
	        break;
	    }
	    if (!l) break;
	    cerr << "recv l=" << l << endl;
	    eod = bp + l;

	    for (cp = bp; cp < eod; cp += l)
	        cout << *cp;
	    cout << endl;
	}
	return RUN_OK;
    }
private:
    Socket* sock;
};

class Writer: public Thread
{
public:
    Writer(const string& name, const SocketAddress& addr):
    	Thread(name), addrptr(addr.clone()) {}

    ~Writer() { delete addrptr; }

    int run() throw(atdUtil::Exception)
    {
	Socket sock(*addrptr);
	Reader reader("psi9116 reader",&sock);
	reader.start();

	char line[64];

	for (;;) {
	    sleep(1);
	    cout << endl << "input: ";
	    cin.getline(line,sizeof(line),'\n');
	    if (cin.eof() || cin.fail()) break;
	    int lout = strlen(line);
	    int l = sock.send(line,lout,0);
	}
	sock.close();
	return RUN_OK;
    }
private:
    SocketAddress* addrptr;
};

int psi_test()
{

    Writer* writer = 0;
    try {
	Inet4SocketAddress addr(Inet4Address::getByName(argvhost),9000);
	writer = new Writer("psi9116 writer",addr);
	writer->start();

    }
    catch(atdUtil::Exception& e) {
        cerr << e.what() << endl;
	return 0;
    }
    try {
	writer->join();
    }
    catch(atdUtil::Exception& e) {
        cerr << e.what() << endl;
    }
    delete writer;
    return 0;
}

int main(int argc, char** argv)
{
    if (argc > 1)
	argvhost = argv[1];
    else
    	argvhost = "localhost";
    if (!psi_test()) return 1;
    return 0;
}

