//
//              Copyright 2004 (C) by UCAR
//

#include <iostream>

#include <unistd.h>

#include <atdUtil/Thread.h>

// #define USE_ATOMIC_OPS
#define USE_MUTEX
// #define USE_VOLATILE

#ifdef USE_ATOMIC_OPS
#include <atomic_ops.h>
#endif

using namespace std;
using namespace atdUtil;

class WriterThread: public Thread 
{
public:
    WriterThread():Thread("Writer"),val(0) {}

#ifdef USE_ATOMIC_OPS
    AO_t getVal() { return AO_load_read(&val); }
#elif defined(USE_MUTEX)

#ifdef USE_VOLATILE
    volatile int getVal() const { Synchronized sync(vmutex); return val; }
#else
    int getVal() const { Synchronized sync(vmutex); return val; }
#endif

#else

#ifdef USE_VOLATILE
    volatile int getVal() const { return val; }
#else
    int getVal() const { return val; }
#endif

#endif
    int run() throw(Exception)
    {
        for (unsigned int i = 0;; i++) {
#ifdef USE_ATOMIC_OPS
	    AO_fetch_and_add1_write(&val);
#elif defined(USE_MUTEX)
	    vmutex.lock(); 	val++; vmutex.unlock();
#else
	    val++;
#endif
	    if (!(i %  1000000)) {
	        testCancel();
		// setCancelEnabled(false);
		// cerr << "i=" << i << " val=" << val << endl;
		// setCancelEnabled(true);
	    }
	}
	return Thread::RUN_OK;
    }
    unsigned long loops;

private:
#ifdef USE_ATOMIC_OPS
    AO_t val;
#else

#ifdef USE_VOLATILE
    volatile int val;
#else
    int val;
#endif

#ifdef USE_MUTEX
    mutable Mutex vmutex;
#endif

#endif
};
	    
class ReaderThread: public Thread 
{
public:
    ReaderThread(WriterThread& w):Thread("Reader"),
    	backwards(0),jumps(0),noinc(0),ninc(0),
	mind(999999999),maxd(0),writer(w) {}
    int run() throw(Exception)
    {
	int lval = writer.getVal();
        for (loops = 0; ; loops++) {
	    volatile int val = writer.getVal();

	    if (val == lval) noinc++;
	    else {
		int d = val - lval;
		if (d == 1) ninc++;
		else if (d < 0) backwards++;
		else {
		    if (d < mind) mind = d;
		    else if (d > maxd) maxd = d;
		    jumps++;
		}
	    }

	    if (!(loops % 1000000)) {
	        testCancel();
		// setCancelEnabled(false);
		// cerr << "i=" << i << " val=" << val << " lval=" << lval << endl;
		// setCancelEnabled(true);
	    }
	    lval = val;
	}
	return 0;
    }
public:
    int loops;
    int backwards;
    int jumps;
    int noinc;
    int ninc;
    int mind;
    int maxd;

private:
    WriterThread& writer;
};
	    

int main(int argc, char** argv)
{

#ifdef USE_ATOMIC_OPS
    cerr << "USE_ATOMIC_OPS" << endl;
#elif defined(USE_MUTEX)
    cerr << "USE_MUTEX" << endl;
#ifdef USE_VOLATILE
    cerr << "USE_VOLATILE" << endl;
#endif

#else
#ifdef USE_VOLATILE
    cerr << "USE_VOLATILE" << endl;
#else
    cerr << "USE_NUTTIN" << endl;
#endif
#endif

    WriterThread t1;
    ReaderThread t2(t1);

    try {
	t1.start();
	t2.start();

	sleep(10);

	cerr << "canceling t2" << endl;
	t2.cancel();
	t2.join();

	t1.cancel();
	t1.join();

	cerr << "final value=" << t1.getVal() << endl;
	cerr << "loops=" << t2.loops << " noinc=" << t2.noinc <<
		" ninc=" << t2.ninc << " jumps=" << t2.jumps <<
		" mind=" << t2.mind << " maxd=" << t2.maxd << 
		" backs=" << t2.backwards << endl;
    }
    catch(const Exception& e) {
        cerr << e.toString() << endl;
    }

}
