// HotController.cpp : Defines the entry point for the console application.
//
#include <stdio.h>
//#include <iostream>
#include <stdlib.h>
#include <math.h>

// function to compute new poisiton of probe based on new direction
// input:  OldDir - present position of probe
//	   NewDir - new direction from sonic data
// output: Step - number of steps to make, the sign determines direction

int ProbePosition(double OD, double ND)
{
    int step;
    double StepSize = 2.5;
    double diff, increment;

    diff = fabs(ND - OD);
//	printf("diff: %f\n", diff);
// if change is less than 17.5 degrees than do nothing
    if(diff >= 17.5) {
		step = int (diff / 5);
		increment = diff - (step * 5.0);
		if (increment >= StepSize) step += 1;
		if ((ND - OD) < 0) step = -step;
    }
    else
		step = 0;

    return step;
}



int main(int argc, char* argv[])
{
    double OldDir, NewDir;
    double Speed;
    float u1, v1, u2, v2;
    int nscan, msecs;
    int Step;

    FILE *pp;

    const double MINSPD = .10;

// initialize 
    OldDir = 0.0;
    Step = 0;

// define the covar process command to get wind data
// you must make sure that this agrees with the statement 
// in the covar.config file
//	const char* cmd = "test.txt";
   const char* cmd = "$ASTER/src/covar/covar -g 1 -A -i 10";

// test by reading u and v componets from a file
	if ((pp = popen(cmd,"r")) == NULL) {
//		printf("pp: %d\n",pp);
        perror(cmd);
	exit(1);
    }	

   // throw away the first set of data from covar
   nscan = fscanf(pp,"%*d %d %f %f %f %f", &msecs, &u1, &v1, &u2, &v2);

// for now stay in an infinite loop
    for (;;) {

//	char a[3],b[3];
/*
// get some data
		if(nscan = fscanf(pp,"%s %s",a,b) < 0) {
			printf("file empty\n");
			fclose(pp);
			return 0;
		}
	u = atof(a);
	v = atof(b);
	printf("nscan=%d   u: %f v: %f\n",nscan,u,v);
*/

	// get some data
	nscan = fscanf(pp,"%*d %d %f %f %f %f",&msecs,&u1,&v1,&u2,&v2);
	printf("nscan=%d   u: %f   v: %f  ", nscan,u1,v1);
	NewDir = (180.0/M_PI)*atan2(v1,u1);
	Speed = sqrt(v1*v1 + u1*u1);
	// check to see if the wind speed is high enough for a direction change
	if (Speed > MINSPD) {
		// call function to compute a new probe position
		Step = ProbePosition(OldDir, NewDir);
		}
	else
		Step = 0;

	printf("Speed: %f NewDir: %f OldDir: %f Step: %d\n", Speed, NewDir, OldDir, Step);
	// change the OldDir to the true new direction for the next interation
	OldDir += Step*5;	
	}
	return 0;
}

