/*              Copyright 2004 (C) by UCAR
 *
 * File       : csat3.h,v
 * Revision   : 1.1
 * Directory  : /code/cvs/isa/src/serial_util/csat3.h,v
 * System     : PAM
 * Date       : 2005/01/16 01:42:23
 *
 * Description:
 *
 * csat3.h,v
 * Revision 1.1  2005/01/16 01:42:23  maclean
 * added copyright
 *
 * Revision 1.1  2004/08/30 05:13:41  maclean
 * *** empty log message ***
 *
 */
                                                                                
#ifndef ATDISFF_CSAT3_H
#define ATDISFF_CSAT3_H


#include <atdISFF/Sampler.h>
#include <atdISFF/SensorPortHandler.h>
#include <atdISFF/CSAT3AsciiOutput.h>

#include <iostream>
#include <string>

namespace atdISFF {

class csat3: public Sampler {

public:

  ~csat3();

  const std::string& getSensorDevName() const { return _devname; }

  const std::string& getName() const { return _name; }
  RawSampleSocket* getRawSampleSocket() const { return 0; }

  void setSensorDevName(const std::string& val) { _devname = val; }

  void init() throw(atdUtil::IOException);

  static int main(int argc, char **argv);
  static void usage(const char* argv0);

  void wait() throw(atdUtil::Exception);
  void interrupt();
  void quit();

  bool getQuit() const { return _quit; }

protected:

  csat3();

  std::string _name;
  std::string _devname;
  /**
   * Client that generates our output.
   */
  RawSampleClient* _rsoutput;

  SensorPortHandler* _sphandler;
  SensorPort* _sensor;

  bool _quit;
};

}

#endif
