//
//              Copyright 2004 (C) by UCAR
//

#include "csat3.h"

#include <atdTermio/SerialPort.h>

using namespace std;
using namespace atdISFF;
using namespace atdUtil;
using namespace atdTermio;

csat3::csat3() :
	Sampler(),_name("csat3"),
	_rsoutput(0),_sphandler(0),_sensor(0),_quit(false)
{
}

void csat3::init() throw(IOException)
{
    _rsoutput = new CSAT3AsciiOutput(cout);

    _sphandler = new SensorPortHandler();
    _sphandler->start();

    SerialPortConfig cfg;		// default settings
    cfg.setChannel(200);
    cfg.setBaud(9600);
    cfg.setDataBits(8);
    cfg.setStopBits(1);
    cfg.setParity(atdTermio::SerialPort::NONE);
    cfg.setFlowControl(atdTermio::SerialPort::NOFLOWCONTROL);
    // cfg.setRecordLength(0);
    //fg.setRecordDelimiter(string(1,'\n'));
    cfg.setRecordLength(10);
    cfg.setDelimiterAtEOM(true);
    cfg.setRecordDelimiter(string("\x55\xaa"));	// csat3 sonic

    _sensor = _sphandler->createSensorPort(getSensorDevName(),cfg);
    _sensor->addRawSampleClient(_rsoutput);

}

csat3::~csat3() {

  delete _sphandler;
  delete _rsoutput;
}

void csat3::wait() throw(Exception)
{
    // cerr << "in csat3::wait(), sphander->join()" << endl;
    _sphandler->join();
}
  
void csat3::interrupt() {
    // cerr << "sending SIGUSR1 to sphandler" << endl;
    _sphandler->interrupt();
    _sphandler->kill(SIGUSR1);

}

void csat3::quit() {
    // cerr << "in csat3::quit()" << endl;
    _quit = true;
    interrupt();
    // cerr << "end of csat3::quit()" << endl;
}
  
/* static */
void csat3::usage(const char* argv0) {
    cerr << "Usage: " << argv0 << "dev_name" << endl;
    exit(1);
}

/* static */
int csat3::main(int argc, char** argv) {

    if (argc < 2) usage(argv[0]);

    int status = 0;
    try {
	csat3* sampler = new csat3;
	sampler->setSensorDevName(argv[1]);
	sampler->init();

	sampler->wait();

	// cerr << "deleting sampler" << endl;
	delete sampler;
    }
    catch (IOException &se) {
      cerr << "IOException in main: " << se.toString() << endl;
      status = 1;
    }
    catch (Exception &e) {
      cerr << "Exception in main: " << e.toString() << endl;
      status = 1;
    }
    return status;
}

int main(int argc, char** argv)
{
    csat3::main(argc,argv);
}
