//
//              Copyright 2004 (C) by UCAR
//

#include <atdISFF/daqmonitor.h>
#include <atdISFF/SensorPort.h>
#include <iostream>
#include <iomanip>
#include <time.h>

using namespace std;

int getDaqStatus(const char *host)
{
  CLIENT *cl;
  daqStatus_res *res;
 
  cl = clnt_create(host,DAQMONITOR_PROG,DAQMONITOR_VERS,"udp");
 
  if (cl == NULL) {
    clnt_pcreateerror(host);
    return -1;
  }
 
  // Average the current system time before and after the call to daqstatus_1
  // Then difference that time with the time reported by daqstatus_1
  struct timeval tval1,tval2;

  gettimeofday(&tval1,0);

  res = daqstatus_1(cl);

  gettimeofday(&tval2,0);
 
  if (res == NULL) {
    clnt_perror(cl,host);
    clnt_destroy(cl);
    return -1;
  }
  clnt_destroy(cl);
 
  if (res->ierr) {
    cerr << "error=" << res->daqStatus_res_u.errmsg << endl;
    return -1;
  }

  long nowsec = tval1.tv_sec + (tval2.tv_sec - tval1.tv_sec) / 2;
  long nowusec = tval1.tv_usec + (tval2.tv_usec - tval1.tv_usec) / 2;

  int msecondsDiff = (nowsec - res->daqStatus_res_u.status.currentTimeSecs) * 1000 +
  	(nowusec -  res->daqStatus_res_u.status.currentTimeUsecs) / 1000;

  cerr << "*** System Status *********************************************************" <<endl;
  time_t ut = res->daqStatus_res_u.status.startTime;
  cerr << "Start time:   " << ctime(&ut);
  ut = res->daqStatus_res_u.status.restartTime;
  cerr << "Restart time: " << ctime(&ut);
  cerr << "                       Socket  Socket    Max    Min" << endl;
  cerr << "  Time  Sample    Lost  Write    Temp Socket Socket Socket Buffered   Total Archive" << endl;
  cerr << "  Diff    Rate Samples Errors Unavail  Write  Write   Rate  Samples Samples  BadTTs" << endl;
  cerr << "  msec     #/s       #      #       #  bytes  bytes byte/s        #       #       #" << endl;  

  cerr << resetiosflags(ios::left) << setiosflags(ios::right);
  cerr << setw(6) << msecondsDiff;
  cerr << setw(8) << setprecision(4) << res->daqStatus_res_u.status.samplesPerSec;
  cerr << setw(8) << res->daqStatus_res_u.status.lostSamples;
  cerr << setw(7) << res->daqStatus_res_u.status.numWriteErrors;
  cerr << setw(8) << res->daqStatus_res_u.status.numWriteTempUnavailable;
  cerr << setw(7) << res->daqStatus_res_u.status.maxWriteLength;
  cerr << setw(7) << res->daqStatus_res_u.status.minWriteLength;
  cerr << setw(7) << res->daqStatus_res_u.status.bytesPerSec;
  cerr << setw(9) << res->daqStatus_res_u.status.rawSampleSetSize;
  cerr << setw(8) << res->daqStatus_res_u.status.rawSamplesInMemory;
  cerr << setw(8) << res->daqStatus_res_u.status.badArchiveTimeTags << endl;
  cerr << "***************************************************************************" << endl << endl;

  cerr << "*** A2D Status ****************************" <<endl;
  cerr << "A2D    Total    5min   Total   User" << endl;
  cerr << "      Sample  Missed  Missed Intrpt" << endl;
  cerr << "        Rate Samples Samples   Rate" << endl;
  cerr << "         #/s       #       #    #/s" << endl;  
  cerr << setw(12) << setprecision(4) << res->daqStatus_res_u.status.a2d.totalSamplesPerSec;
  cerr << setw(8) << res->daqStatus_res_u.status.a2d.missedSamples;
  cerr << setw(8) << res->daqStatus_res_u.status.a2d.cumulativeMissedSamples;
  cerr << setw(7) << res->daqStatus_res_u.status.a2d.userInterruptRate << endl;

  cerr << endl;
  cerr << "    A2D Sample" << endl;
  cerr << "channel   Rate MinV MaxV  VRes" << endl;
  cerr << "      #    #/s    V    V    uV" << endl;
  for (a2dChannelStatus *ap = res->daqStatus_res_u.status.a2ds; ap;
  	ap = ap->next) {
    cerr << setw(7) << ap->channelNum;
    cerr << setw(7) << setprecision(4) << ap->sampleRate;
    cerr << setw(5) << setprecision(4) << ap->minV;
    cerr << setw(5) << setprecision(4) << ap->maxV;
    cerr << setw(6) << setprecision(4) << ap->uVresolution << endl;
  }
  cerr << "*******************************************" << endl << endl;

  cerr << "*** Serial Port Status ****************************************************************************" <<endl;
  int maxnamelen = 0;
  int maxseplen = 4;
  int l;
  for (sensorPortStatus *sp = res->daqStatus_res_u.status.ports; sp;
  	sp = sp->next) {
    if ((l = strlen(sp->devname)) > maxnamelen) maxnamelen = l;

    // if ((l = strlen(sp->messageSeparator)) > maxseplen) maxseplen = l;

    string prms = atdISFF::SensorPort::printableMessageSeparator(sp->messageSeparator);
    if ((l = prms.size()) > maxseplen) maxseplen = l;
  }

  cerr << 
    "port        " <<
    setw(maxnamelen + 11) << 
	"flow" <<
    setw(maxseplen+1) <<
	" Msg" <<
	" Sep" <<
	" Msg" <<
	"  read" <<
	" sampl" <<
	"  min" <<
	"  max" <<
	" readerrs" <<
	" writerrs" <<
	" overflow" << endl;

  cerr <<
    setw(maxnamelen) << 
    resetiosflags(ios::right) << setiosflags(ios::left) <<
  	"name" <<
    setw(5) << 
    resetiosflags(ios::left) << setiosflags(ios::right) <<
  	"chan" <<
    setw(7) << 
	"baud" <<
	" p/d/s" <<
	" cntl" <<
    setw(maxseplen+1) <<
	" Sep" <<
	" Loc" <<
	" Len" <<
  	"  /sec" <<
  	"  /sec" <<
  	" read" <<
	" read" <<
	" 5min cum" <<
	" 5min cum" <<
	" 5min cum" << endl;;


  for (sensorPortStatus *sp = res->daqStatus_res_u.status.ports; sp;
  	sp = sp->next) {
    string prms = atdISFF::SensorPort::printableMessageSeparator(sp->messageSeparator);
    cerr <<
      setw(maxnamelen) << 
      resetiosflags(ios::right) << setiosflags(ios::left) <<
	sp->devname <<
      setw(5) << 
      resetiosflags(ios::left) << setiosflags(ios::right) <<
	sp->channelNum <<
      setw(7) <<
	sp->baudRate << ' ' <<
	sp->parity[0] << '/' <<
	sp->dataBits << '/' <<
	sp->stopBits <<
      setw(5) << 
	sp->flowcontrol <<
      setw(maxseplen+1) << 
	prms <<
      setw(4) << 
	(sp->separatorAtEOM ? "EOM" : "BOM") <<
      setw(4) <<
	sp->messageLength <<
      setw(6) << setprecision(3) <<	// gcc2 can't right justify here...
      	sp->readsPerSecond <<
      setw(6) << setprecision(3) <<
	sp->samplesPerSecond <<
      setw(5) <<
	(sp->minReadLength > 999999 ? 0 : sp->minReadLength) <<
      setw(5) <<
	sp->maxReadLength <<
      setw(4) <<
	sp->readErrorCount <<
      setw(5) <<
	sp->cumReadErrorCount <<
      setw(4) <<
	sp->writeErrorCount <<
      setw(5) <<
	sp->cumWriteErrorCount <<
      setw(4) <<
	sp->bufferOverflowCount <<
      setw(5) <<
	sp->cumBufferOverflowCount << endl;
  }
  cerr << "***************************************************************************************************" <<endl << endl;
  xdr_free((bool_t(*)(XDR*,void*,...))xdr_daqStatus_res,(char *)res);
  return 0;
}

int usage(const char *argv0) {
  cerr << "Usage: " << argv0 << " data_acq_hostname" << endl;
  exit(1);
}

int main(int argc, char** argv) {
  if (argc != 2) usage(argv[0]);
  const char* host = argv[1];
  getDaqStatus(host);
}

