//
//              Copyright 2004 (C) by UCAR
//

#include <atdISFF/daqmonitor.h>
#include <iostream>
#include <iomanip>

using namespace std;

int daqRestart(const char *host)
{
  CLIENT *cl;
  void *res;
 
  cl = clnt_create(host,DAQMONITOR_PROG,DAQMONITOR_VERS,"udp");
 
  if (cl == NULL) {
    clnt_pcreateerror(host);
    return -1;
  }
 
  res = daqrestart_1(cl);

  if (res == NULL) {
    clnt_perror(cl,host);
    clnt_destroy(cl);
    return -1;
  }
  clnt_destroy(cl);
 
  xdr_free((bool_t(*)(XDR*,void*,...))xdr_void,(char *)res);
  return 0;
}

int usage(const char *argv0) {
  cerr << "Usage: " << argv0 << " data_acq_hostname" << endl;
  exit(1);
}

int main(int argc, char** argv) {
  if (argc != 2) usage(argv[0]);
  const char* host = argv[1];
  daqRestart(host);
}

