//
//              Copyright 2004 (C) by UCAR
//

#include <iostream>
#include <dsc/UserClockedPrometheusA2DSampler.h>

using namespace dsc;
using namespace std;

UserClockedPrometheusA2DSampler::UserClockedPrometheusA2DSampler(
	int ioPortAddress,
	int irq,
	bool differential,
	bool bipolar,atdISFF::TimerThread* timer):
    // virtual base class
    atdISFF::A2DSampler(DscBoard::makeName(DSC_PROM,ioPortAddress,irq)),
    // virtual base class
    dsc::A2DSampler(DSC_PROM,ioPortAddress,irq),
    dsc::PrometheusA2DSampler(ioPortAddress,irq,differential,bipolar),
    dsc::UserClockedA2DSampler(DSC_PROM,ioPortAddress,irq,timer)
{
}

UserClockedPrometheusA2DSampler::~UserClockedPrometheusA2DSampler() {
}

void UserClockedPrometheusA2DSampler::init()
	throw(atdUtil::IOException,atdUtil::InvalidParameterException) {
  // Initialize base classes first.
  dsc::UserClockedA2DSampler::init();
}

float UserClockedPrometheusA2DSampler::getMaximumSamplingRate() const {
  return 1.e3;		// initial guess - not tested
}
