//
//              Copyright 2004 (C) by UCAR
//

#ifndef DSC_PROMETHEUSA2DSAMPLER_H
#define DSC_PROMETHEUSA2DSAMPLER_H

#include <dsc/DscA2DSampler.h>

namespace dsc {

class PrometheusA2DSampler : public virtual dsc::A2DSampler {

public:
  /**
   * The constructor for PrometheusA2DSampler.
   * The ioPortAddress defaults to 0x280, but can
   * be changed in the bios.  The IRQ is changed with
   * jumper block J10.
   * Differential/single-ended and bipolar/unipolar is
   * set in jumper block J13.
   */
  PrometheusA2DSampler(int ioPortAddress,int irq,
  	bool differential, bool bipolar);

  virtual ~PrometheusA2DSampler();

  /**
   * Size of FIFO on Prometheus
   */
  int getMaxFifoLength() const { return 48; }

};
}

#endif
