//
//              Copyright 2004 (C) by UCAR
//

#include <iostream>
#include <dsc/PrometheusA2DSampler.h>

#include <assert.h>

using namespace dsc;
using namespace std;

PrometheusA2DSampler::PrometheusA2DSampler(
	int ioPortAddress,
	int irq,
	bool differential,
	bool bipolar):
    // virtual base class
    atdISFF::A2DSampler(DscBoard::makeName(DSC_PROM,ioPortAddress,irq)),
    // base class
    dsc::A2DSampler(DSC_PROM,ioPortAddress,irq)
{

  int nvoltageRanges = 4;
  float maxv[] = { 10.0, 5.0, 2.5, 1.25 };
  assert(sizeof maxv / sizeof maxv[0] == nvoltageRanges);

  // gain setting that correspond to the above + voltages
  int gains[] = { GAIN_1, GAIN_2, GAIN_4, GAIN_8 };
  assert(sizeof gains / sizeof gains[0] == nvoltageRanges);
  gainSettings.insert(gainSettings.begin(),gains,gains+nvoltageRanges);

  // range setting that correspond to the above + voltages
  // On the prometheus, using RANGE_5 doesn't provide any different
  // voltage ranges than RANGE_10 (GAIN_8 is not supported
  // with RANGE_5).  So we'll use RANGE_10 for everything.
  int ranges[] = { RANGE_10, RANGE_10, RANGE_10, RANGE_10 }; 
  assert(sizeof ranges / sizeof ranges[0] == nvoltageRanges);
  rangeSettings.insert(rangeSettings.begin(),ranges,ranges+nvoltageRanges);

  /* polarity is set with jumpers */
  int polvalue = bipolar ? BIPOLAR : UNIPOLAR;
  int polarities[] = { polvalue, polvalue, polvalue, polvalue };
  assert(sizeof polarities / sizeof polarities[0] == nvoltageRanges);
  polaritySettings.insert(polaritySettings.begin(),
  	polarities,polarities+nvoltageRanges);
  
  // Page 182,Diamond Systems Corp, Universal Driver Software User's Guide,
  // v5.7:  Prometheus returns -32768:32767 for all voltage ranges.
  for (unsigned int i = 0; i < sizeof(maxv) / sizeof(maxv[0]); i++) {
    // UNIPOLAR, GAIN_8 is not supported.
    // Since GAIN_8 is the last gain, it is OK not to add a
    // value to vRanges.
    if (polarities[i] != UNIPOLAR || gains[i] != GAIN_8) {
      float* vs = new float[3];
      vs[0] = polarities[i] == BIPOLAR ? -maxv[i] : 0.0f;// minimum voltage

      // For unipolar, these max voltages are double the
      // DSC documentation for the Prometheus.
      vs[1] =  polarities[i] == BIPOLAR ? maxv[i] : maxv[i]*2;	// max voltage
      vs[2] =  (vs[1] - vs[0]) / 65535.0e-6f;	// voltage resolution, microV
      vRanges.push_back(vs);
      conversionSlopes.push_back((vs[1] - vs[0]) / 65535.0f);
      conversionIntercepts.push_back(
      	polarities[i] == BIPOLAR ? 0.0f : vs[1]/2.0f);
    }
  }

  /* 8 differential, 16 single-ended */
  maxNumberOfChannels = differential ? 8 : 16;
}

PrometheusA2DSampler::~PrometheusA2DSampler() {
  for (unsigned int i = 0; i < vRanges.size(); i++) delete [] vRanges[i];
}

