//
//              Copyright 2004 (C) by UCAR
//

#ifndef DSC_PROMDIGITALIO_H
#define DSC_PROMDIGITALIO_H

#include <dsc/DscDigitalIO.h>

/* Bits in Digital I/O Control Register (base+11) of Prometheus */
#define PROM_DIRA	0x10	// 0=bits 0-7 output, 1=input
#define PROM_DIRB	0x02	// 0=bits 8-15 output, 1=input
#define PROM_DIRC_LOW	0x01	// 0=bits 16-19 output, 1=input
#define PROM_DIRC_HIGH	0x08	// if DIOCTR=0, 0=bits 20-23 output, 1=input
#define PROM_DIOCTR	0x80	// 0=bits 16-23 are I/O, 1=counters

namespace dsc {

/**
 * Class to drive digital output lines on a Diamond Systems prometheus.
 */
class PromDigitalOut : public DscDigitalOut {

public:

    /**
     * constructor
     */
    PromDigitalOut(int ioPortAddress,int irq):
    	DscDigitalOut(DSC_PROM,ioPortAddress,irq),
		currentState(getNumberOfOutputs())
    {
    }
    
    PromDigitalOut(): DscDigitalOut(),currentState(getNumberOfOutputs())
    {
    }

    /**
     * destructor
     */
    ~PromDigitalOut() {}

    int getNumberOfOutputs() throw() { return 24; }

    void reserveOutputs(const atdUtil::BitArray& lines)
    	throw(atdUtil::IOException);

    void write(const atdUtil::BitArray& lines, const atdUtil::BitArray& state)
    	throw(atdUtil::IOException);

    atdUtil::BitArray read(const atdUtil::BitArray& lines) throw(atdUtil::IOException);

    atdUtil::BitArray read() throw(atdUtil::IOException);

protected:

    atdUtil::BitArray currentState;

};

/**
 * Class to read digital input lines on a Diamond Systems card.
 */
class PromDigitalIn : public DscDigitalIn {

public:

    /**
     * constructor
     */
    PromDigitalIn(int ioPortAddress,int irq):
  	DscDigitalIn(DSC_PROM,ioPortAddress,irq)
    {
    }

    PromDigitalIn(): DscDigitalIn()
    {
    }

    /**
     * destructor
     */
    ~PromDigitalIn() {}

    int getNumberOfInputs() throw() { return 24; }

    void reserveInputs(const atdUtil::BitArray& lines) throw(atdUtil::IOException);

    atdUtil::BitArray read(const atdUtil::BitArray& lines) throw(atdUtil::IOException);

    atdUtil::BitArray read() throw(atdUtil::IOException);

protected:

};

}

#endif
