//
//              Copyright 2004 (C) by UCAR
//

#include <dsc/PromDigitalIO.h>

#include <iostream>
#include <sstream>
#include <iomanip>
#include <stdio.h>

using namespace std;
using namespace dsc;

void PromDigitalOut::reserveOutputs(const atdUtil::BitArray& lines)
	throw(atdUtil::IOException)
{
    // set all ports to input, and if any bits in ports A,B or C are
    // requested, set those ports to output.
    // Don't turn on DIOCTR, since perhaps PromDigitalIn wants
    // it disabled.
    unsigned char dio_ctrl =
    	PROM_DIRA | PROM_DIRB | PROM_DIRC_LOW | PROM_DIRC_HIGH;

    if (lines.any(0,8)) dio_ctrl &= ~PROM_DIRA;
    if (lines.any(8,16)) dio_ctrl &= ~PROM_DIRB;
    if (lines.any(16,20)) dio_ctrl &= ~PROM_DIRC_LOW;
    if (lines.any(20,24)) dio_ctrl &= ~(PROM_DIRC_HIGH | PROM_DIOCTR);

    BYTE result;
    if ((result = dscDIOSetConfig(getDSCB(),&dio_ctrl)) != DE_NONE) {
	ERRPARAMS errorParams;
	dscGetLastError(&errorParams);
	throw atdUtil::IOException(getDeviceName(),
	    "dscDIOSetConfig", errorParams.errstring);
    }
    DscDigitalOut::reserveOutputs(lines);

    currentState = read(lines);	// initialize currentState of output lines
}

void PromDigitalOut::write(const atdUtil::BitArray& mask,
	const atdUtil::BitArray& newState) throw(atdUtil::IOException)
{
    // lines whose state needs to be changed
    atdUtil::BitArray toChange = (currentState ^ newState) & mask;
    currentState ^= toChange;	// flip state of bits to be changed

    BYTE result;

    for (int i = 0; i < 3; i++) {
	int fbit = i * 8;
	if (fbit >= toChange.getLength()) break;
	int lbit = std::min(fbit + 8,toChange.getLength());

	if (toChange.any(fbit,lbit)) {
	    unsigned char obyte = (unsigned char) currentState.getBits(fbit,lbit);
	    if ((result = dscDIOOutputByte(getDSCB(),i,obyte)) != DE_NONE) {
		ERRPARAMS errorParams;
		dscGetLastError(&errorParams);
		throw atdUtil::IOException(getDeviceName(),
		    "dscDIOOutputByte", errorParams.errstring);
	    }
	}
    }
}
atdUtil::BitArray PromDigitalOut::read(const atdUtil::BitArray& mask)
	throw(atdUtil::IOException)
{
    atdUtil::BitArray res(mask.getLength());
    BYTE result;

    for (int i = 0; i < 3; i++) {
	int fbit = i * 8;
	if (fbit >= res.getLength()) break;
	int lbit = std::min(fbit + 8,res.getLength());
	if (mask.any(fbit,lbit)) {
	    unsigned char ibyte;
	    if ((result = dscDIOInputByte(getDSCB(),i,&ibyte)) != DE_NONE) {
		ERRPARAMS errorParams;
		dscGetLastError(&errorParams);
		throw atdUtil::IOException(getDeviceName(),
		    "dscDIOOutputByte", errorParams.errstring);
	    }
	    res.setBits(fbit,lbit,ibyte);
	}
    }
#ifdef DEBUG
    if (((res ^ currentState) & mask).any()) {
        cerr << "read result=" << endl << res.toString() << endl;
        cerr << "currentState=" << endl << currentState.toString() << endl;
    }
#endif
  
    return res & mask;
}

atdUtil::BitArray PromDigitalOut::read() throw(atdUtil::IOException)
{
    return atdISFF::DigitalOut::read();
}

void PromDigitalIn::reserveInputs(const atdUtil::BitArray& lines)
	throw(atdUtil::IOException)
{
    // set all ports to output, and if any bits in ports A,B or C are
    // requested, set those ports to input.
    unsigned char dio_ctrl = 0;

    if (lines.any(0,8)) dio_ctrl |= PROM_DIRA;
    if (lines.any(8,16)) dio_ctrl |= PROM_DIRB;
    if (lines.any(16,20)) dio_ctrl |= PROM_DIRC_LOW;
    // Bug: we have to leave PROM_DIOCTR off here in case
    // DigitalOut wants to use it as an output.
    // We need to be able to read the config byte!
    if (lines.any(20,24)) dio_ctrl |= PROM_DIRC_HIGH;

    BYTE result;
    if ((result = dscDIOSetConfig(getDSCB(),&dio_ctrl)) != DE_NONE) {
	ERRPARAMS errorParams;
	dscGetLastError(&errorParams);
	throw atdUtil::IOException(getDeviceName(),
	    "dscDIOSetConfig", errorParams.errstring);
    }
    DscDigitalIn::reserveInputs(lines);
}

atdUtil::BitArray PromDigitalIn::read(const atdUtil::BitArray& lines) throw(atdUtil::IOException)
{
    atdUtil::BitArray res(lines.getLength());
    BYTE result;

    for (int i = 0; i < 3; i++) {
	int fbit = i * 8;
	if (fbit >= res.getLength()) break;
	int lbit = std::min(fbit + 8,res.getLength());
	if (lines.any(fbit,lbit)) {
	    unsigned char ibyte;
	    if ((result = dscDIOInputByte(getDSCB(),i,&ibyte)) != DE_NONE) {
		ERRPARAMS errorParams;
		dscGetLastError(&errorParams);
		throw atdUtil::IOException(getDeviceName(),
		    "dscDIOInputByte", errorParams.errstring);
	    }
	    res.setBits(fbit,lbit,ibyte);
	}
    }
    return res & lines;
}

atdUtil::BitArray PromDigitalIn::read() throw(atdUtil::IOException)
{
    return atdISFF::DigitalIn::read();
}

