//
//              Copyright 2004 (C) by UCAR
//

#include <iostream>
#include <dsc/MM32XAT_A2DSampler.h>

#include <assert.h>

using namespace dsc;
using namespace std;

MM32XAT_A2DSampler::MM32XAT_A2DSampler(
	int ioPortAddress,
	int irq,
	bool differential,
	bool bipolar):
    // virtual base class
    atdISFF::A2DSampler(DscBoard::makeName(DSC_DMM32XAT,ioPortAddress,irq)),
    // base class
    dsc::A2DSampler(DSC_DMM32XAT,ioPortAddress,irq)
{

  int nvoltageRanges = 5;
  float maxv[] = { 10.0, 5.0, 2.5, 1.25, 0.625 };
  assert(sizeof maxv / sizeof maxv[0] == nvoltageRanges);

  // gain setting that correspond to the above + voltages
  int gains[] = { GAIN_1, GAIN_2, GAIN_4, GAIN_8, GAIN_8 };
  assert(sizeof gains / sizeof gains[0] == nvoltageRanges);
  gainSettings.insert(gainSettings.begin(),gains,gains+nvoltageRanges);

  int ranges[] = { RANGE_10, RANGE_10, RANGE_10, RANGE_10, RANGE_5 }; 
  assert(sizeof ranges / sizeof ranges[0] == nvoltageRanges);
  rangeSettings.insert(rangeSettings.begin(),ranges,ranges+nvoltageRanges);

  /* polarity is software settable, no jumpers */
  int polvalue = bipolar ? BIPOLAR : UNIPOLAR;
  int polarities[] = { polvalue, polvalue, polvalue, polvalue, polvalue };
  assert(sizeof polarities / sizeof polarities[0] == nvoltageRanges);
  polaritySettings.insert(polaritySettings.begin(),
  	polarities,polarities+nvoltageRanges);
  
  // Page 182,Diamond Systems Corp, Universal Driver Software User's Guide,
  // v5.7:  MM32XAT_ returns -32768:32767 for all voltage ranges.
  for (unsigned int i = 0; i < sizeof(maxv) / sizeof(maxv[0]); i++) {
    // UNIPOLAR, RANGE_5 is not supported on the MM32XAT
    if (polarities[i] != UNIPOLAR || ranges[i] != RANGE_5) {
      float* vs = new float[3];
      vs[0] = polarities[i] == BIPOLAR ? -maxv[i] : 0.0f;// minimum voltage

      vs[1] =  polarities[i] == BIPOLAR ? maxv[i] : maxv[i];	// max voltage
      vs[2] =  (vs[1] - vs[0]) / 65535.0e-6f;	// voltage resolution, microV
      vRanges.push_back(vs);
      conversionSlopes.push_back((vs[1] - vs[0]) / 65535.0f);
      conversionIntercepts.push_back(
      	polarities[i] == BIPOLAR ? 0.0f : vs[1]/2.0f);
    }
  }

  /* 16 differential, 32 single-ended */
  maxNumberOfChannels = differential ? 16 : 32;
}

MM32XAT_A2DSampler::~MM32XAT_A2DSampler() {
  for (unsigned int i = 0; i < vRanges.size(); i++) delete [] vRanges[i];
}

