//
//              Copyright 2004 (C) by UCAR
//

#ifndef DSC_MM16AT_A2DSAMPLER_H
#define DSC_MM16AT_A2DSAMPLER_H

#include <dsc/DscA2DSampler.h>

namespace dsc {

class MM16AT_A2DSampler : public virtual dsc::A2DSampler {

public:
  /**
   * The constructor for MM16AT_A2DSampler.
   * ioPortAddress 
   * IRQ is changed with
   * Differential/single-ended and bipolar/unipolar is
   * set in jumper block J13.
   */
  MM16AT_A2DSampler(int ioPortAddress,int irq,
  	bool differential, bool bipolar);

  virtual ~MM16AT_A2DSampler();

  /**
   * Size of FIFO on MM16AT
   */
  int getMaxFifoLength() const { return 512; }

};
}

#endif
