//
//              Copyright 2004 (C) by UCAR
//

#ifndef DSC_IR104_H
#define DSC_IR104_H

#include <atdISFF/Relay.h>

#include <dsc/DscBoard.h>

namespace dsc {

/**
 * Encapsulation of a Diamond Systems Corporation IR104
 * relay board.
 * Typical usage:
 *   IR104 ir104(0x260);
 *   ir104.openRelays();
 *   ...
 *   atdUtil::BitArray& bits = ir104.getRelayBits();
 *   bits.setBit(4,1);
 *   bits.setBit(12,1);
 *   bits.setBit(19,1);
 *   ir104.setRelays();
 *   ...
 */
class IR104 : public atdISFF::Relay {

public:

  /**
   * constructor
   */
  IR104(int ioPortAddress,int irq) throw(atdUtil::IOException);

  /**
   * destructor
   */
  virtual ~IR104() throw(atdUtil::IOException);

  void openRelays() throw(atdUtil::IOException) {
    relayBits.setBits(0);
    setRelays();
  }

  /**
   * Returns a reference to the BitArray for this relay object.
   * One can then set/clear some bits on the BitArray, and then
   * do setRelays() to change the relay state. 
   * Note that the returned BitArray doesn't necessarily reflect
   * the present state of the relays.  One does readRelays()
   * to get the present relay state, or setRelays() to
   * change the relays to the bit settings in BitArray.
   */
  atdUtil::BitArray& getRelayBits() { return relayBits; }

  void setRelayBits(const atdUtil::BitArray& val) {
    relayBits = val;
  }

  /**
   * Set the relays to the current value of the relay mask.
   */
  void setRelays() throw(atdUtil::IOException);

  /**
   * Does a actual read of the current state of the relays
   * and returns the state in BitArray.
   */
  atdUtil::BitArray& readRelays() throw(atdUtil::IOException);

  const std::string& getName() const { return name; }

  DSCB getDSCB() const { return board->getDSCB(); }

  /**
   * Test function.
   */
  static int main(int argc, char **argv); 

protected:

  DscBoard* board;

  /**
   * A bit array, one bit for each relay
   */
  atdUtil::BitArray relayBits;

  std::string name;

  bool overridden;
};

}

#endif
