//
//              Copyright 2004 (C) by UCAR
//

#include <dsc/IR104.h>
#include <dsc/DiamondUD.h>

#include <iostream>
#include <sstream>
#include <iomanip>
#include <stdio.h>

using namespace std;
using namespace dsc;
using namespace atdISFF;
/**
 * Create a BitArray of length 20, one bit for each relay on the IR104,
 * Call DSCUD board initialization routine, and read current state
 * of relays. Finally open all relays.
 */
IR104::IR104(int ioPortAddress,int irq) throw(atdUtil::IOException):
	board(DscBoard::getInstance(DSC_IR104,ioPortAddress,irq)),
	relayBits(20),name(board->getName())
{

  openRelays();
}

/**
 * Call DSCUD free board routine.
 */
IR104::~IR104() throw(atdUtil::IOException)
{
  DscBoard::release(board);
}

/**
 * Set relays to current value of relayBits.
 */
void IR104::setRelays() throw(atdUtil::IOException) {
  unsigned char* bitsPtr = relayBits.getPtr();
  for (unsigned char group = 0;
  	group < 3 && group < relayBits.getLengthInBytes(); group++) {
    unsigned char gbits = bitsPtr[group];
    if (group == 2) gbits &= 0xf;
    if (dscSetRelayMulti(getDSCB(),group,gbits) != DE_NONE) {
      ERRPARAMS errorParams;
      dscGetLastError(&errorParams);
      throw atdUtil::IOException(getName(),"dscSetRelayMulti",errorParams.errstring);
    }
  }
}

/**
 * Read current status of relays.
 */
atdUtil::BitArray& IR104::readRelays() throw(atdUtil::IOException) {

  // use larger BitArray if necessary
  if (relayBits.getLength() < 20) relayBits = atdUtil::BitArray(20);

  unsigned char* bitsPtr = relayBits.getPtr();
  for (unsigned char group = 0;
  	group < relayBits.getLengthInBytes() && group < 3; group++) {
    if (dscGetRelayMulti(getDSCB(),group,bitsPtr+group) != DE_NONE) {
      ERRPARAMS errorParams;
      dscGetLastError(&errorParams);
      throw atdUtil::IOException(getName(),"dscGetRelayMulti",errorParams.errstring);
    }
    // cerr << "relay group=" << group << " bits=" << hex << (unsigned int)bitsPtr[group] << dec << endl;
  }
  // cerr << "relayBits=" << relayBits.toString() << endl;
  return relayBits;
}

/* static */
/**
 * test program for the IR104.
 */
int IR104::main(int argc, char** argv) {

  int ioPort = 0x260;
  int irq = 4;

  int status = 0;

  try {
  
    /* this invokes the constructor */
    IR104 ir104(ioPort,irq);

    atdUtil::BitArray &bits = ir104.getRelayBits();
    
    for (;;) {

      cout << "Enter the relay number to toggle (0 to " <<
      	bits.getLength() - 1 << ") or -1 to exit : ";

      int relayNum;
      cin >> relayNum;
      if (cin.eof()) break;

      // if state of input stream is not good, eat a character and try again.
      if (!cin.good()) {
	char cbad;
        cin >> cbad;
	continue;
      }

      if (relayNum < 0 || relayNum > bits.getLength()) break;
      int rval = bits.getBit(relayNum);
      
      rval = (rval == 0) ? 1 : 0;

      bits.setBit(relayNum,rval);

      ir104.setRelays();

      bits = ir104.readRelays();

      cout << bits.toString() << endl;

    }
    /* destructor for ir104 will be invoked here */
  }
  catch (atdUtil::IOException &ioe) {
    cerr << ioe.toString() << endl;
    status = 1;
  }
  dsc::DiamondUD::freeUD();
  return status;
}

