//
//              Copyright 2004 (C) by UCAR
//

#include <iostream>
#include <dsc/ExtClockedMM32XAT_A2DSampler.h>

using namespace dsc;
using namespace atdISFF;
using namespace atdUtil;
using namespace std;

/* static */
ExtClockedMM32XAT_A2DSampler* ExtClockedMM32XAT_A2DSampler::_instance = 0;

/* static */
ExtClockedMM32XAT_A2DSampler* ExtClockedMM32XAT_A2DSampler::createInstance(
	int ioPortAddress,
	int irq,
	bool differential,
	bool bipolar)
	{
  if (!_instance) _instance =
  	new ExtClockedMM32XAT_A2DSampler(ioPortAddress,irq,differential,bipolar);
  return _instance;
}

ExtClockedMM32XAT_A2DSampler::ExtClockedMM32XAT_A2DSampler(
	int ioPortAddress,
	int irq,
	bool differential,
	bool bipolar):
    // virtual base class
    atdISFF::A2DSampler(DscBoard::makeName(DSC_DMM32XAT,ioPortAddress,irq)),
    // virtual base class
    dsc::A2DSampler(DSC_DMM32XAT,ioPortAddress,irq),
    dsc::MM32XAT_A2DSampler(ioPortAddress,irq,differential,bipolar),
    dsc::ExtClockedA2DSampler(DSC_DMM32XAT,ioPortAddress,irq)
{
  availableSamplingRates.push_back(2000);
  availableSamplingRates.push_back(1000);
  availableSamplingRates.push_back(200);
  availableSamplingRates.push_back(100);
  availableSamplingRates.push_back(20);
  availableSamplingRates.push_back(1);
}

ExtClockedMM32XAT_A2DSampler::~ExtClockedMM32XAT_A2DSampler() {
  _instance = 0;
}

void ExtClockedMM32XAT_A2DSampler::init() throw(IOException,InvalidParameterException) {
  // cerr << "ExtClockedMM32XAT_A2DSampler::init()" << endl;

  // Initialize base classes first.
  dsc::ExtClockedA2DSampler::init();

  int numScanned = getNumChannelsScanned();

  float samplesPerSec = numScanned * getMaxRequestedSamplingRate();

#ifdef DEBUG
  cerr << "maxFifoLength=" << getMaxFifoLength() <<
  	", numScanned=" << numScanned <<
	", samplesPerSec=" << samplesPerSec <<
	", maxRequestedSamplingRate=" << getMaxRequestedSamplingRate() << endl;
#endif

  // avoid divide by zero
  if (numScanned == 0) fifoDepth = 1;
  else {
    // To avoid hardware FIFO overflow, the upper limit for
    // fifoDepth should be about 1/2 the size of the FIFO.
    // When the FIFO fills to that level, then a hardware interrupt
    // is generated.
    // fifoDepth / samplesPerSec = seconds between hardware interrupts
    fifoDepth = (getMaxFifoLength() / 2 / numScanned) * numScanned;

    // Want at least 4 interrupts per second for timely data.
    if (fifoDepth > samplesPerSec/4) fifoDepth = (int)rint(samplesPerSec/4);
    if (fifoDepth < numScanned) fifoDepth = numScanned;
    else fifoDepth = (fifoDepth / numScanned) * numScanned;	// multiple of numScanned

    // On MM32XAT fifoDepth must be even number. If it is odd at this
    // point then we must be scanning an odd number of channels.
    // Subtract numScanned to make it even.
    if ((fifoDepth % 2)) fifoDepth -= numScanned;
    // else if (fifoDepth < getMaxFifoLength() / 2) fifoDepth += 2 * numScanned;
  }

  // number of hardware interrupts per second
  // An interrupt happens when nsamples==fifoDepth
  int hwIntsPerSec = (int)rint(samplesPerSec / fifoDepth);

  // desired number of software interrupts per second
  // A software interrupt happens when nsamples==dumpThreshold
  int swIntsPerSec = 2;
  int nfifo = hwIntsPerSec / swIntsPerSec;
  if (nfifo < 1) nfifo = 1;

  dumpThreshold = fifoDepth * nfifo;

  // cerr << "dumpThreshold=" << dumpThreshold << endl;

  numConversions = dumpThreshold * 16;		// N buffer

  setupUserInterruptFunction();
}

/**
 * Function that is registered with the DSC Universal Driver, with
 * dscSetUserInterruptFunction(dscb,...). It is called with
 * data is available in the sample buffer. We'll support
 * only one MM32XAT_ A2D in a system, so we can gets its instance,
 * and call the dscUserIntFunc method.
 */
/* static */
void dsc::ExtClockedMM32XAT_A2DSampler::staticDscUserIntFunc(void *dummy) {
  isff_sys_time_t dtime = getCurrentTimeInMillis();
  ExtClockedMM32XAT_A2DSampler::getInstance()->dscUserIntFunc(dtime);
}
