//
//              Copyright 2004 (C) by UCAR
//

#ifndef DSC_EXTCLOCKEDMM16AT_A2DSAMPLER_H
#define DSC_EXTCLOCKEDMM16AT_A2DSAMPLER_H

#include <dsc/MM16AT_A2DSampler.h>
#include <dsc/DscExtClockedA2DSampler.h>

namespace dsc {

/**
 * Finally we tie it all together.
 */
class ExtClockedMM16AT_A2DSampler : 
	public MM16AT_A2DSampler,
	public ExtClockedA2DSampler {

  ExtClockedMM16AT_A2DSampler(int ioPortAddress,int irq,
  	bool differential, bool bipolar);

public:

  static ExtClockedMM16AT_A2DSampler* createInstance(int ioPortAddress,
  	int irq, bool differential, bool bipolar);

  /**
   * Must have a static way to get the instance of the sampler,
   * because the interrupt function needs it.
   */
  static ExtClockedMM16AT_A2DSampler* getInstance() { return _instance; }

  virtual ~ExtClockedMM16AT_A2DSampler();

  void init() throw(atdUtil::IOException,atdUtil::InvalidParameterException);

protected:

  /**
   * Function that is registered with the DSC Universal Driver, with
   * dscSetUserInterruptFunction(dscb,...). It is called when
   * data is available in the sample buffer. Since there can be
   * only one MM16AT_ A2D in a system, we can gets its instance,
   * and call the dscUserIntFunc method.
   * One cannot pass a parameter to the staticDscUserIntFunc.
   * According to the DSC docs, it is there for windoze compatibilty.
   * 
   */
  static void staticDscUserIntFunc(void *dummy);

  /**
   * Virtual method to return a pointer to the DSCUserInterruptFunction
   * for this A2D.
   */
  DSCUserInterruptFunction getStaticDscUserIntFunc()
  	{ return staticDscUserIntFunc; }

  static ExtClockedMM16AT_A2DSampler* _instance;

};
}

#endif
