//
//              Copyright 2004 (C) by UCAR
//

#ifndef DSC_USERCLOCKEDA2DSAMPLER_H
#define DSC_USERCLOCKEDA2DSAMPLER_H

#include <atdISFF/UserClockedA2DSampler.h>
#include <atdISFF/TimerThread.h>
#include <atdISFF/Time.h>
#include <dsc/DscA2DSampler.h>

namespace dsc {

/**
 * Partial implementation of an atdISFF::UserClockedA2DSampler using
 * Diamond Systems Corp Universal Driver calls.
 * It uses the dsc::A2DSampler implementation of atdISFF::A2DSampler,
 * which must be virtual, and adds some implementation of the
 * atdISFF::UserClockedA2DSampler interface.
 */

class UserClockedA2DSampler :
	public virtual dsc::A2DSampler,
	public atdISFF::UserClockedA2DSampler {

public:
  UserClockedA2DSampler(int type,int ioPortAddr, int irq,
	atdISFF::TimerThread* timer);
  virtual ~UserClockedA2DSampler();

  void addChannel(int userChannelNum, int vRangeIndex, float samplingRate)
  	throw(atdUtil::IOException,atdUtil::InvalidParameterException);

  float getSamplingRate(int userChannelNum) const {
    return requestedSamplingRates[channelMapVec[userChannelNum-100]];
  }

  /**
   * must be called after adding all channels, and before start;
   */
  void init() throw(atdUtil::IOException,atdUtil::InvalidParameterException);

  int run() throw(atdUtil::Exception);

protected:

  void checkSamplingRate(float sRate) throw(atdUtil::InvalidParameterException);
  void checkSamplingRates(float maxrate,float sRate) throw(atdUtil::InvalidParameterException);

  std::vector<float> requestedSamplingRates;

  DSCADSCAN dscadscan;

  void doScan() throw(atdUtil::IOException);

  void doConversions() throw(atdUtil::IOException);

  float maxRequestedSamplingRate;

  /**
   * Time in milliseconds between conversion scans.
   */
  int deltatMsec;

  /*
   * Do an A2D scan every Nth time we are waked by timer thread.
   */
  int scanEvery;

  /**
   * Used to check that we're sampling at the correct frequency.
   */
  atdISFF::isff_sys_time_t tlast;
  /**
   * Used to check that we're sampling at the correct frequency.
   */
  int tdiffcheck;

};
}

#endif
