//
//              Copyright 2004 (C) by UCAR
//

#ifndef DSC_DSCDIGITALIO_H
#define DSC_DSCDIGITALIO_H

#include <atdISFF/DigitalIO.h>
#include <dsc/DscBoard.h>

namespace dsc {

/**
 * Abstract class to drive digital output lines on a Diamond Systems card.
 */
class DscDigitalOut : public atdISFF::DigitalOut {

public:

    /**
     * constructor
     */
    DscDigitalOut(int type,int ioPortAddress, int irq):
  	boardType(type),boardAddr(ioPortAddress),boardIrq(irq),
	board(0),reservedOutputs(getNumberOfOutputs())
    {
    }

    DscDigitalOut():
  	boardType(0),boardAddr(0),boardIrq(0),board(0),
	reservedOutputs(getNumberOfOutputs())
    {
    }

    /**
     * destructor
     */
    ~DscDigitalOut();

    void setDeviceName(const std::string& val);

    const std::string& getDeviceName() const { return devname; }

    void open() throw(atdUtil::IOException);

    void open(const std::string& name) throw(atdUtil::IOException);

    void close() throw(atdUtil::IOException);

    int getNumberOfOutputs() throw() { return 24; }

    void reserveOutputs(const atdUtil::BitArray& lines) throw(atdUtil::IOException);

    const atdUtil::BitArray& getReservedOutputs() const throw() 
    {
        return reservedOutputs;
    }

    // atdUtil::BitArray read() throw(atdUtil::IOException); 

protected:
    std::string devname;

    int boardType;

    int boardAddr;

    int boardIrq;

    dsc::DscBoard* board;

    atdUtil::BitArray reservedOutputs;

    DSCB getDSCB() const
    {
	if (!board) return -1;
        return board->getDSCB();
    }

};

/**
 * Abstract class to read digital input lines on a Diamond Systems card.
 */
class DscDigitalIn : public atdISFF::DigitalIn {

public:

    /**
     * constructor
     */
    DscDigitalIn(int type,int ioPortAddress,int irq):
  	boardType(type),boardAddr(ioPortAddress),boardIrq(irq),
	board(0),
	reservedInputs(getNumberOfInputs())
    {
    }

    DscDigitalIn():
  	boardType(0),boardAddr(0),boardIrq(0),board(0),
	reservedInputs(getNumberOfInputs())
    {
    }

    /**
     * destructor
     */
    ~DscDigitalIn();

    void setDeviceName(const std::string& val);

    const std::string& getDeviceName() const { return devname; }

    void open() throw(atdUtil::IOException);

    void open(const std::string& name) throw(atdUtil::IOException);

    void close() throw(atdUtil::IOException);

    int getNumberOfInputs() throw() { return 24; }

    void reserveInputs(const atdUtil::BitArray& lines) throw(atdUtil::IOException);

    const atdUtil::BitArray& getReservedInputs() const throw() 
    {
        return reservedInputs;
    }

    // atdUtil::BitArray read() throw(atdUtil::IOException); 

protected:
    std::string devname;

    int boardType;

    int boardAddr;

    int boardIrq;

    dsc::DscBoard* board;

    atdUtil::BitArray reservedInputs;

    DSCB getDSCB() const
    {
	if (!board) return -1;
        return board->getDSCB();
    }

};

}

#endif
