//
//              Copyright 2004 (C) by UCAR
//

#include <dsc/DscDigitalIO.h>

#include <iostream>
#include <sstream>
#include <iomanip>
#include <stdio.h>

using namespace std;
using namespace dsc;

DscDigitalOut::~DscDigitalOut()
{
    if (board) dsc::DscBoard::release(board);
}

void DscDigitalOut::setDeviceName(const std::string& val)
{
    devname = val;
}

void DscDigitalOut::open() throw(atdUtil::IOException)
{
    if (boardAddr == 0) {
	try {
	    DscBoard::parseName(devname,boardType,boardAddr,boardIrq);
	}
	catch(const atdUtil::ParseException& e) {
	    throw atdUtil::IOException(devname,"open",e.what());
	}
    }
    cerr << "dsc::DscBoard::getInstance,boardType=" << boardType <<
    	" boardAddr=" << hex << boardAddr << dec << " irq=" << boardIrq << endl;
    board = dsc::DscBoard::getInstance(boardType,boardAddr,boardIrq);
    cerr << "dsc::DscBoard::getInstance done" << endl;
    devname = board->getName();
}

void DscDigitalOut::open(const string& name) throw(atdUtil::IOException)
{
    devname = name;
    try {
	DscBoard::parseName(devname,boardType,boardAddr,boardIrq);
    }
    catch(const atdUtil::ParseException& e) {
        throw atdUtil::IOException(name,"open",e.what());
    }
    board = dsc::DscBoard::getInstance(boardType,boardAddr,boardIrq);
}

void DscDigitalOut::close() throw(atdUtil::IOException)
{
    if (board) dsc::DscBoard::release(board);
    board = 0;
}

void DscDigitalOut::reserveOutputs(const atdUtil::BitArray& lines)
	throw(atdUtil::IOException)
{
    reservedOutputs = lines;
}

// atdUtil::BitArray DscDigitalOut::read() throw(atdUtil::IOException)
// {
//     return read(getReservedOutputs());
// }

DscDigitalIn::~DscDigitalIn()
{
    if (board) dsc::DscBoard::release(board);
}

void DscDigitalIn::setDeviceName(const std::string& val)
{
    devname = val;
}

void DscDigitalIn::open() throw(atdUtil::IOException)
{
    if (boardAddr == 0) {
	try {
	    DscBoard::parseName(devname,boardType,boardAddr,boardIrq);
	}
	catch(const atdUtil::ParseException& e) {
	    throw atdUtil::IOException(devname,"open",e.what());
	}
    }
    board = dsc::DscBoard::getInstance(boardType,boardAddr,boardIrq);
    devname = board->getName();
}

void DscDigitalIn::open(const std::string& name) throw(atdUtil::IOException)
{
    devname = name;
    try {
	DscBoard::parseName(devname,boardType,boardAddr,boardIrq);
    }
    catch(const atdUtil::ParseException& e) {
        throw atdUtil::IOException(name,"open",e.what());
    }
    cerr << "dsc::DscBoard::getInstance,boardType=" << boardType <<
    	" boardAddr=" << hex << boardAddr << dec << " irq=" << boardIrq << endl;
    board = dsc::DscBoard::getInstance(boardType,boardAddr,boardIrq);
    cerr << "dsc::DscBoard::getInstance done" << endl;
}

void DscDigitalIn::close() throw(atdUtil::IOException)
{
    if (board) dsc::DscBoard::release(board);
    board = 0;
}

void DscDigitalIn::reserveInputs(const atdUtil::BitArray& lines)
	throw(atdUtil::IOException)
{
    reservedInputs = lines;
}

// atdUtil::BitArray DscDigitalIn::read() throw(atdUtil::IOException)
// {
//     return read(getReservedInputs());
// }


