//
//              Copyright 2004 (C) by UCAR
//

#ifndef DSC_DSCBOARD_H
#define DSC_DSCBOARD_H

#include <string>
#include <map>

// diamond driver includes
#include <dscud.h>

#include <atdUtil/IOException.h>
#include <atdUtil/ParseException.h>
#include <atdUtil/ThreadSupport.h>

namespace dsc {

/**
 * Base class for Diamond Systems Corp (DSC) A2Ds which use the
 * Universal Driver (DSCUD).  Implement the part of
 * atdISFF::A2DSampler that is common to all DSC A2Ds.
 * Derived classes should set the appropriate voltage
 * ranges, gains, polarities, etc.
 */
class DscBoard {

public:

    /**
     * Static method to get a pointer to a DSC board with
     * the given type, address and irq (which may be 0).
     * When the user is done with the pointer, call the
     * release static method.
     */
    static DscBoard* getInstance(int type,int ioPortAddr, int irq)
	throw(atdUtil::IOException);

    static DscBoard* getInstance(const std::string& name)
	throw(atdUtil::IOException,atdUtil::ParseException);
    /**
     * Indicate that a user no longer needs the DSC board.
     */
    static void release(DscBoard*) throw(atdUtil::IOException);

    static std::string makeName(int type,int ioPortAddr,int irq);

    static std::string getTypeName(int type);

    static void parseName(const std::string& name,
    	int &type, int& ioPortAddress, int& irq)
		throw(atdUtil::ParseException);

    const std::string& getName() const { return name; }

    int type;

    DSCB getDSCB() { return dscb; }

    int getIrq() const { return dsccb.int_level; }

protected:

    DscBoard();

    /**
     * Destructor.
     */
    ~DscBoard();

    void open(int type,int ioPortAddr, int irq)
	throw(atdUtil::IOException);

    void close() throw(atdUtil::IOException);

    int incRefCount();

    int decRefCount();

    static std::map<std::string,DscBoard*> boards;

    // handle used to refer to the board
    DSCB dscb;

    // structure containing board settings
    DSCCB dsccb;

    std::string name;

    atdUtil::Mutex refMutex;

    int refCount;

};
}

#endif
