//
//              Copyright 2004 (C) by UCAR
//

#ifndef DSC_DIAMONDUD_H
#define DSC_DIAMONDUD_H

namespace dsc {

/**
 * static functions to call the Diamond Universal Driver functions
 * dscInit and dscFree.  dscInit must be called before any
 * threads are started, so we call initUD in a static
 * initializer.
 */
class DiamondUD {
public:
  /**
   * calls dscInit().
   */
  static bool initUD();

  /**
   * calls dscFree().
   * Call once before program exit, though not strictly necessary.
   */
  static void freeUD();

private:
  static bool initCheck;
public:
  static bool freeDone;
  static bool initDone;
};

}

#endif
