//
//              Copyright 2004 (C) by UCAR
//

// diamond driver includes
#include <dscud.h>
#include <iostream>

#include <dsc/DiamondUD.h>
#include <atdUtil/IOException.h>

using namespace std;

/* static */
bool dsc::DiamondUD::initCheck = false;

/* static */
bool dsc::DiamondUD::freeDone = false;

/* static */
/**
 * This static initialization forces the dscInit() to be done
 * at program load time.  If one does a check of initDone
 * in a constructor for an object that uses the Diamond Universal
 * Driver, then it will be linked into the program, and
 * the initialization done at load time.
 */
bool dsc::DiamondUD::initDone = dsc::DiamondUD::initUD();

/* static */
bool dsc::DiamondUD::initUD() {

  if (!initCheck) {

    //===================================================================
    // I. DRIVER INITIALIZATION
    //
    //    Initializes the DSCUD library.
    //
    //    STEPS TO FOLLOW:
    //
    //	  1. initialize the driver, using the driver version for validation
    //=====================================================================

    // diamond systems FAQ:
    /*
      If you are using the Universal Driver in a multi-threaded program on
      Linux, make sure you call dscInit() before creating your first thread.
      Calling dscInit() after creating threads will fail to set the correct
      I/O permissions in Linux for all threads, and Linux will generate a
      segfault on any attempt by the driver to do direct I/O from within a thread.
    */

    cerr << "dscInit" << endl;
    if( dscInit( DSC_VERSION ) != DE_NONE )
    {
      ERRPARAMS errorParams;
      dscGetLastError(&errorParams);
      atdUtil::IOException ioe("Diamond Universal Driver","dscInit",errorParams.errstring);
      cerr << ioe.toString() << endl;
      exit(1);
    }
    initCheck = true;
  }
  return true;
}

/* static */
void dsc::DiamondUD::freeUD() {
  if (!freeDone) {	// this isn't thread safe - shouldn't be necessary.
    cerr << "doing dscFree()" << endl;
    if(dscFree() != DE_NONE) {
      ERRPARAMS errorParams;
      dscGetLastError(&errorParams);
      atdUtil::IOException ioe("Diamond Universal Driver","dscFree",errorParams.errstring);
      cerr << ioe.toString() << endl;
      exit(1);
    }
    freeDone = true;
  }
}

