//
//              Copyright 2004 (C) by UCAR
//


#ifndef ATDUTIL_XMLSTRINGCONVERTER_H
#define ATDUTIL_XMLSTRINGCONVERTER_H

#include<xercesc/util/XMLString.hpp>

namespace atdUtil {
class XMLStringConverter {
private:
  char *str;
  XMLCh *xstr;
  bool releaseChar;
public:

    XMLStringConverter(const XMLCh* val) :
    	str(xercesc::XMLString::transcode(val)),xstr(val),releaseChar(true) {}

    XMLStringConverter(const char* val) :
    	str(val),xstr(xercesc::XMLString::transcode(val)),releaseChar(false) {}

    ~XMLStringConverter() { 
  	if (releaseChar) xercesc::XMLString::release(&str);
  	else xercesc::XMLString::release(&xstr);
    }

    /**
     * Conversion to const char*
     */
    operator const char*() const { return str; }
    operator const XMLCh*() const { return xstr; }
};
}

#endif
