//
//              Copyright 2004 (C) by UCAR
//

#ifndef ATDUTIL_XMLSAX2PARSER_H
#define ATDUTIL_XMLSAX2PARSER_H

#include <atdUtil/XMLSAX2Handler.h>
#include <atdUtil/ParseException.h>
#include <string>
#include <stdexcept>

namespace atdUtil {

class XMLSAX2Parser {
public:
  XMLSAX2Parser(XMLSAX2Handler *handler) throw(std::runtime_error);
  ~XMLSAX2Parser();

  void parse(const char* string, int len) throw(ParseException);

protected:
  LPXMLPARSER parsifal;
  XMLSAX2Handler *handler;

  std::string parseErrorString;

  static int staticStartDocumentHandler(void *UserData);

  static int staticEndDocumentHandler(void *UserData);

  static int staticStartElementHandler(void *UserData, const XMLCH *uri,
  	const XMLCH *localname, const XMLCH *qname, LPXMLVECTOR atts);

  static int staticEndElementHandler(void *UserData, const XMLCH *uri,
  	const XMLCH *localname, const XMLCH *qname);

  static int staticCharactersHandler(void *UserData, const XMLCH* chars,
  	int length);

  static void staticErrorHandler(LPXMLPARSER parsifal);

  void errorHandler();

};

}

#endif
