//
//              Copyright 2004 (C) by UCAR
//

#include <atdUtil/XMLSAX2Parser.h>

#include <sstream>

using namespace atdUtil;

struct ParserStringInput {
  const char *cp;
  int len;
};

static int parserStringInputFunc(BYTE *buf, int cBytes, int *cBytesActual,
	void *inputData) {
  struct ParserStringInput* ss = (struct ParserStringInput*) inputData;
  int len = ss->len < cBytes ? ss->len : cBytes;
  memcpy(buf,ss->cp,len);
  ss->len -= len;
  ss->cp += len;
  *cBytesActual = len;
  return len < cBytes;
}

XMLSAX2Parser::XMLSAX2Parser(XMLSAX2Handler* h) throw(std::runtime_error) :
	handler(h),parsifal(0) {
  
  // this only fails on malloc errors
  if (!XMLParser_Create(&parsifal))
    throw std::runtime_error("could not allocate an LPXMLPARSER");

  parsifal->UserData = this;
  parsifal->errorHandler = staticErrorHandler;
  parsifal->startDocumentHandler = staticStartDocumentHandler;
  parsifal->endDocumentHandler = staticEndDocumentHandler;
  parsifal->startElementHandler = staticStartElementHandler;
  parsifal->endElementHandler = staticEndElementHandler;
  parsifal->charactersHandler = staticCharactersHandler;
  _XMLParser_SetFlag(parsifal,XMLFLAG_NAMESPACES,0);
  _XMLParser_SetFlag(parsifal,XMLFLAG_EXTERNAL_GENERAL_ENTITIES,0);
}

XMLSAX2Parser::~XMLSAX2Parser() {
  if (parsifal) XMLParser_Free(parsifal);
}

void XMLSAX2Parser::parse(const char* str, int len) throw(ParseException) {
  struct ParserStringInput stringInput = { str,len };
  parseErrorString = std::string("unknown parse error");
  if (!XMLParser_Parse(parsifal,parserStringInputFunc,&stringInput,(const unsigned char*) "US-ASCII"))
	throw ParseException(parseErrorString);
}

/* static */
int XMLSAX2Parser::staticStartDocumentHandler(void* userData)
{
  XMLSAX2Handler* handler = ((XMLSAX2Parser*)userData)->handler;
  return handler->startDocumentHandler();
}

/* static */
int XMLSAX2Parser::staticEndDocumentHandler(void* userData)
{
  XMLSAX2Handler* handler = ((XMLSAX2Parser*) userData)->handler;
  return handler->endDocumentHandler();
}

/* static */
int XMLSAX2Parser::staticStartElementHandler(void* userData,
     const XMLCH *uri,
     const XMLCH *localname,
     const XMLCH *qname,
     LPXMLVECTOR atts)
{
  XMLSAX2Handler* handler = ((XMLSAX2Parser*) userData)->handler;
  return handler->startElementHandler(uri,localname,qname,atts);
}

/* static */
int XMLSAX2Parser::staticEndElementHandler(void* userData,
     const XMLCH *uri,
     const XMLCH *localname,
     const XMLCH *qname)
{
  XMLSAX2Handler* handler = ((XMLSAX2Parser*) userData)->handler;
  return handler->endElementHandler(uri,localname,qname);
}

/* static */
int XMLSAX2Parser::staticCharactersHandler(void* userData,
	const XMLCH* chars,int cbSize)
{
  XMLSAX2Handler* handler = ((XMLSAX2Parser*) userData)->handler;
  return handler->charactersHandler(chars,cbSize);
}

/* static */
void XMLSAX2Parser::staticErrorHandler(LPXMLPARSER parsifal)
{
  XMLSAX2Parser* parser = (XMLSAX2Parser*) parsifal->UserData;
  parser->errorHandler();
}

void XMLSAX2Parser::errorHandler() {
  std::ostringstream ost;
  if (parsifal->ErrorCode != ERR_XMLP_ABORT) {
    XMLCH *sysID = XMLParser_GetSystemID(parsifal);

    if (sysID) ost << "Parsing " << sysID << " failed. ";
    ost << "Error: " << parsifal->ErrorString <<
    	", ErrorCode: " << parsifal->ErrorCode << 
	", Line: " << parsifal->ErrorLine << 
	", Column: " << parsifal->ErrorColumn;
  }
  else ost << "XMLParser: ERR_XMLP_ABORT";
  parseErrorString = ost.str();
}

