/*              Copyright 2004 (C) by UCAR
 *
 * File       : NumConverter.h,v
 * Revision   : 1.4
 * Directory  : /code/cvs/isa/src/lib/atdUtil/NumConverter.h,v
 * Date       : 2005/11/21 05:29:43
 *
 * Description:
 *   
 *
 */

#ifndef ATDUTIL_NUMCONVERTER_H
#define ATDUTIL_NUMCONVERTER_H

namespace atdUtil {

class NumConverter {
public:

  virtual ~NumConverter() {}

  enum endianness { NC_UNKNOWN_ENDIAN, NC_BIG_ENDIAN, NC_LITTLE_ENDIAN };
  typedef enum endianness endianness;

  static endianness hostEndianness;

  static endianness getHostEndianness() { return hostEndianness; }

  static const NumConverter* getNumConverter(endianness input, endianness output);

  static const NumConverter* getNumConverter(endianness input);

  virtual double doubleValue(const char *) const = 0;
  virtual float floatValue(const char *) const = 0;
  virtual long longValue(const char *) const = 0;
  virtual unsigned long ulongValue(const char *) const = 0;
  virtual short shortValue(const char *) const = 0;
  virtual unsigned short ushortValue(const char *) const = 0;
private:
  static endianness privGetHostEndianness();

  static NumConverter* flipConverter;
  static NumConverter* noflipConverter;
};

class FlipConverter : public NumConverter {
public:

  virtual ~FlipConverter() {}

  double doubleValue(const char *) const;
  float floatValue(const char *) const;
  long longValue(const char *) const;
  unsigned long ulongValue(const char *) const;
  short shortValue(const char *) const;
  unsigned short ushortValue(const char *) const;
};

class NoFlipConverter : public NumConverter {
public:
  virtual ~NoFlipConverter() {}

  double doubleValue(const char *) const;
  float floatValue(const char *) const;
  long longValue(const char *) const;
  unsigned long ulongValue(const char *) const;
  short shortValue(const char *) const;
  unsigned short ushortValue(const char *) const;
};
}
#endif
