
//
//              Copyright 2004 (C) by UCAR
//

#include <stdexcept>
#include <atdUtil/NumConverter.h>

using namespace atdUtil;

NumConverter::endianness NumConverter::hostEndianness =
	NumConverter::privGetHostEndianness();

NumConverter* NumConverter::flipConverter = new FlipConverter();

NumConverter* NumConverter::noflipConverter = new NoFlipConverter();

NumConverter::endianness NumConverter::privGetHostEndianness() {
    endianness endian;
    union {
	long l;
	char c[4];
    } test;
    test.l = 1;
    if(test.c[3] == 1 && (test.c[2] == test.c[1] == test.c[0] == 0) )
    endian = NC_BIG_ENDIAN;
    else if(test.c[3] == 0 && (test.c[2] == test.c[1] == test.c[0] == 1) )
    endian = NC_LITTLE_ENDIAN;
    else endian = NC_UNKNOWN_ENDIAN;
    return endian;
}

const NumConverter* NumConverter::getNumConverter(
	NumConverter::endianness input,
	NumConverter::endianness output)
{
    if (input == output) return noflipConverter;
    else return flipConverter;
}

const NumConverter* NumConverter::getNumConverter(
	NumConverter::endianness input)
{
    return getNumConverter(input,getHostEndianness());
}

double
NoFlipConverter::doubleValue(const char *p) const {
  union {
    double v;
    char b[8];
  } u;
  memcpy(u.b,p,sizeof(double));
  return u.v;
}

float
NoFlipConverter::floatValue(const char *p) const {
  union {
    float v;
    char b[4];
  } u;
  memcpy(u.b,p,sizeof(float));
  return u.v;
}

long
NoFlipConverter::longValue(const char *p) const {
  union {
    long v;
    char b[4];
  } u;
  u.b[0] = p[0];
  u.b[1] = p[1];
  u.b[2] = p[2];
  u.b[3] = p[3];
  return u.v;
}

unsigned long
NoFlipConverter::ulongValue(const char *p) const {
  union {
    unsigned long v;
    char b[4];
  } u;
  u.b[0] = p[0];
  u.b[1] = p[1];
  u.b[2] = p[2];
  u.b[3] = p[3];
  return u.v;
}

short
NoFlipConverter::shortValue(const char *p) const {
  union {
    short v;
    char b[2];
  } u;
  u.b[0] = p[0];
  u.b[1] = p[1];
  return u.v;
}

unsigned short
NoFlipConverter::ushortValue(const char *p) const {
  union {
    unsigned short v;
    char b[2];
  } u;
  u.b[0] = p[0];
  u.b[1] = p[1];
  return u.v;
}

double
FlipConverter::doubleValue(const char *p) const {
  union {
    double v;
    char b[8];
  } u;
  u.b[7] = p[0];
  u.b[6] = p[1];
  u.b[5] = p[2];
  u.b[4] = p[3];
  u.b[3] = p[4];
  u.b[2] = p[5];
  u.b[1] = p[6];
  u.b[0] = p[7];
  return u.v;
}

float
FlipConverter::floatValue(const char *p) const {
  union {
    float v;
    char b[4];
  } u;
  u.b[3] = p[0];
  u.b[2] = p[1];
  u.b[1] = p[2];
  u.b[0] = p[3];
  return u.v;
}

long
FlipConverter::longValue(const char *p) const {
  union {
    long v;
    char b[4];
  } u;
  u.b[3] = p[0];
  u.b[2] = p[1];
  u.b[1] = p[2];
  u.b[0] = p[3];
  return u.v;
}

unsigned long
FlipConverter::ulongValue(const char *p) const {
  union {
    unsigned long v;
    char b[4];
  } u;
  u.b[3] = p[0];
  u.b[2] = p[1];
  u.b[1] = p[2];
  u.b[0] = p[3];
  return u.v;
}

short
FlipConverter::shortValue(const char *p) const {
  union {
    short v;
    char b[2];
  } u;
  u.b[1] = p[0];
  u.b[0] = p[1];
  return u.v;
}

unsigned short
FlipConverter::ushortValue(const char *p) const {
  union {
    unsigned short v;
    char b[2];
  } u;
  u.b[1] = p[0];
  u.b[0] = p[1];
  return u.v;
}
