//
//              Copyright 2004 (C) by UCAR
//
// Description:
//

#ifndef ATDUTIL_INVALIDPARAMETEREXCEPTION_H
#define ATDUTIL_INVALIDPARAMETEREXCEPTION_H

#include <string>
#include <atdUtil/Exception.h>

namespace atdUtil {

  class InvalidParameterException : public Exception {

  public:
 
    /**
     * Create an InvalidParameterException, passing a name of the
     * software or hardware module, the name of the parameter, and
     * a message.
     */
    InvalidParameterException(const std::string& module,
	const std::string& name, const std::string& msg):
      Exception("InvalidParameterException", module + ": " +
		name + ": " + msg)
    {}

    /**
     * Create an InvalidParameterException, passing a message.
     */
    InvalidParameterException(const std::string& message):
      Exception(message) {}

    /**
     * clone myself (a "virtual" constructor).
     */
    Exception* clone() const {
      return new InvalidParameterException(*this);
    }
  };
}

#endif
