/*              Copyright (C) by UCAR
 *
 * Description:
 */

#ifndef ATDTERMIO_SERIALPORT_H
#define ATDTERMIO_SERIALPORT_H

#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <string>
#include <iostream>

#include <atdTermio/Termios.h>
#include <atdUtil/IOException.h>

namespace atdTermio {

class SerialOptions;

class SerialPort : public Termios {

public:

  SerialPort(const std::string& name);

  /**
   * For serial port that is already open (stdin for example).
   * */
  SerialPort(const std::string& name, int fd) throw (atdUtil::IOException);

  /**
   * close the file descriptor if is is open.
   */
  virtual ~SerialPort();

  /**
   * Device name of the SerialPort.
   */
  const std::string& getName() const { return _name; }

  /**
   * open the device file. Do setTermioConfig() to set the termios options.
   */
  virtual int open(int mode = O_RDONLY) throw (atdUtil::IOException);

  /**
   * close the file descriptor.
   */
  void close();

  int &fd() { return _fd; }

  int getModemFlags() throw (atdUtil::IOException);
  int getCarrierDetect() throw (atdUtil::IOException);
  static std::string modemFlagsToString(int modem);

  /**
   * If one changes options on a currently open device, then
   * one must call setTermioConfig for them to take effect.
   */
  void setTermioConfig() throw (atdUtil::IOException);

  /**
   * Not normally needed by the user.
   */
  void getTermioConfig() throw (atdUtil::IOException);

  void setBlocking(bool val) throw(atdUtil::IOException);
  bool getBlocking() throw(atdUtil::IOException);

  int flushInput() throw(atdUtil::IOException);
  int flushOutput() throw(atdUtil::IOException);
  int flushBoth() throw(atdUtil::IOException);

  int timeoutOrEOF() const { return _state == TIMEOUT_OR_EOF; }

  virtual int readline(char *buf,int len) throw(atdUtil::IOException);
  virtual int read(char *buf,int len) throw(atdUtil::IOException);
  virtual char readchar() throw(atdUtil::IOException);

  virtual int write(const char *buf,int len) throw(atdUtil::IOException);


private:

  int _fd;

  std::string _name;

  enum state { OK, TIMEOUT_OR_EOF} _state;

  char *_savep;
  char *_savebuf;
  int _savelen,_savealloc;

  bool blocking;
};

}
#endif
