//
//              Copyright 2004 (C) by UCAR
//

#ifndef ATDISFF_RRELAYLISTENER_H
#define ATDISFF_RRELAYLISTENER_H

#include <atdISFF/relays/RrelayConnection.h>
#include <atdISFF/RawSampleSource.h>
#include <atdUtil/Thread.h>
#include <atdUtil/IOException.h>

#define RRELAY_PORT 8101

namespace atdISFF {

/**
 * Remote relay. A class which provides remote control
 * of a relay.
 */
class RrelayListener : public atdUtil::Thread {
public:

  RrelayListener(RelayProgram& r, RawSampleSource* src) throw(atdUtil::IOException);
  ~RrelayListener();

  int run() throw(atdUtil::Exception);

  void interrupt();

  // static const int RRELAY_PORT;

private:
  int listenfd;

  atdUtil::Mutex connectionLock;
  std::list<RrelayConnection*> connections;

  RelayProgram& relayProgram;
  RawSampleSource* sampleSource;
};

}
#endif
