//
//              Copyright 2004 (C) by UCAR
//

#ifndef ATDISFF_RRELAYCONNECTION_H
#define ATDISFF_RRELAYCONNECTION_H

#include <atdISFF/RawSampleSource.h>
#include <atdISFF/relays/RelayProgram.h>
#include <atdUtil/Thread.h>

#include <iostream>
#include <ext/stdio_filebuf.h>

namespace atdISFF {

/**
 * Remote relay. A class which provides remote control
 * of a relay.
 */
class RrelayConnection : public atdUtil::Thread {
public:
  RrelayConnection(int fd,RelayProgram& rly,RawSampleSource*src);
  ~RrelayConnection();

  int run() throw(atdUtil::Exception);

  /**
   * make a name for the thread.
   */
  static std::string makeName(int fd);

  static int numConn;

private:
  void pauseOutput(RawSampleClient*);
  void resumeOutput(RawSampleClient*);
  void showHelp(std::ostream&);
  void toggleRelay(int relaynum) throw(atdUtil::IOException);
  void showRelays(std::ostream&);
  void openRelays() throw(atdUtil::IOException);

   RawSampleSource* sampleSource;
   RelayProgram& relayProgram;

   // __gnu_cxx::stdio_filebuf<char> iobuf;
   // std::istream iostr;
   int sockfd;

};

}

#endif


