//
//              Copyright 2004 (C) by UCAR
//

#include <atdISFF/relays/RrelayConnection.h>
#include <atdISFF/AsciiRawSampleOutputStream.h>
#include <atdISFF/Sampler.h>

using namespace std;
using namespace atdISFF;
using namespace atdUtil;

#include <iostream>
#include <sstream>
#include <stdio.h>
#include <unistd.h>
#include <ext/stdio_filebuf.h>
using namespace std;

RrelayConnection::RrelayConnection(int fd, RelayProgram& rly,
	RawSampleSource *src):
  Thread(makeName(fd)),sampleSource(src),relayProgram(rly),sockfd(fd)
{
  blockSignal(SIGINT);
  blockSignal(SIGHUP);
  blockSignal(SIGTERM);
  unblockSignal(SIGUSR1);
  start();
}

RrelayConnection::~RrelayConnection()
{
  /* close the socket */
  if (sockfd >= 0) ::close(sockfd);
}

/* static */
int RrelayConnection::numConn = 0;

/* static */
string RrelayConnection::makeName(int fd) {
  ostringstream os;
  os << "RrelayConnection#" << numConn++ << "(fd=" << fd << ")";
  return os.str();
}

int RrelayConnection::run() throw(atdUtil::Exception)
{
  // unbuffered input

  {
#if __GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ > 3)
      __gnu_cxx::stdio_filebuf<char> ibuf(sockfd,ios_base::in,1);
      __gnu_cxx::stdio_filebuf<char> obuf(sockfd,ios_base::out,512);
#else
      __gnu_cxx::stdio_filebuf<char> ibuf(sockfd,ios_base::in,false,1);

      __gnu_cxx::stdio_filebuf<char> obuf(sockfd,ios_base::out,false,512);
#endif
      std::istream istr(&ibuf);
      std::ostream ostr(&obuf);

      AsciiRawSampleOutputStream airout(ostr);

      showHelp(ostr);

      // int iread = 0;

      for (bool quit = false; !quit ;) {

	if (amInterrupted()) break;
	char cmd;
	istr >> cmd;
	if (!istr) break;
	// if (! (iread++ % 10)) cerr << "iread=" << iread << endl;
	// cerr << "RrelayConnection read character=" << cmd << endl;
	switch (cmd) {
	case 'h':
	case '?':
	  pauseOutput(&airout); 	showHelp(ostr);
	  break;
	case 's':
	    pauseOutput(&airout);	showRelays(ostr);
	    break;
	case 'p':
	    pauseOutput(&airout);
	    break;
	case 'g':
	    resumeOutput(&airout);
	    break;
	case 'o':
	    openRelays();		showRelays(ostr);
	    break;
	case 'q':
	    quit = true;
	    break;
	case '0': case '1': case '2': case '3': case '4':
	case '5': case '6': case '7': case '8': case '9':
	  {
	    int relaynum;
	    // put character back, read number. Number must then
	    // be delimited by something non-numeric.
	    istr.putback(cmd);
	    istr >> relaynum;
	    if (!istr) {
	      istr.clear();
	      break;
	    }
	    toggleRelay(relaynum);
	    showRelays(ostr);
	  }
	  break;
	case 'r':
	    relayProgram.setOverride(false);
	    break;
	case 'Q':
	    Sampler::getInstance()->kill(SIGINT);
	    break;
	default:	break;	// ignore junk
	}
      }
      sampleSource->removeRawSampleClient(&airout);
  }
  relayProgram.setOverride(false);
  ::close(sockfd);
  sockfd = -1;
  cerr << "RrelayConnection::run finished" << endl;
  return RUN_OK;
}
void RrelayConnection::pauseOutput(RawSampleClient* clnt) {
  sampleSource->removeRawSampleClient(clnt);
}
void RrelayConnection::resumeOutput(RawSampleClient* clnt) {
  sampleSource->addRawSampleClient(clnt);
}
void RrelayConnection::showHelp(std::ostream& ostr) {
  atdUtil::BitArray& relaybits = relayProgram.getRelay()->getRelayBits();
  int nrelays = relaybits.getLength();
  ostr << "Commands:\n\
h: stop output, show this help.  Enter g to restart output\n\
?: same as h\n\
p: pause output\n\
g: go, restart output\n\
s: show state of relays in binary form (0=open,1=closed).\n\
   Enter g to restart output\n\
o: open all relays\n\
number <space or return>: toggle a relay open->closed or closed->open.\n\
  You must enter a space or carriage return after the number.\n\
  There are " << nrelays << " relays, so enter a number\n\
  between 0 and " << nrelays - 1 << ".\n\
r: resume relay program control of relays\n\
q: quit rrelay (relay program will resume control)\n\
Q: terminate entire data acquisition program" << endl;
}

void RrelayConnection::toggleRelay(int relaynum) throw(atdUtil::IOException) {
  Relay* relay = relayProgram.getRelay();
  atdUtil::BitArray& relaybits = relay->getRelayBits();
  if (relaynum < 0 || relaynum >= relaybits.getLength()) return;// silent

  if (!relayProgram.getOverride()) relayProgram.setOverride(true);
  int bit = relaybits.getBit(relaynum);
  bit = (bit == 0) ? 1 : 0;
  relaybits.setBit(relaynum,bit);
  relay->setRelays();
}

void RrelayConnection::openRelays() throw(atdUtil::IOException) {
  if (!relayProgram.getOverride()) relayProgram.setOverride(true);
  Relay* relay = relayProgram.getRelay();
  relay->openRelays();
}
void RrelayConnection::showRelays(std::ostream& ostr) {
  Relay* relay = relayProgram.getRelay();
  const atdUtil::BitArray& relaybits = relay->readRelays();
  ostr << "relays "  <<
  	(relayProgram.getOverride() ? "(user override): " : ":  ") << endl << 
	relaybits.toString() << endl;
}
