//
//              Copyright 2004 (C) by UCAR
//

#ifndef ATDISFF_RELAYSEQUENCE_H
#define ATDISFF_RELAYSEQUENCE_H

#include <atdISFF/relays/RelaySetting.h>

#include <vector>
#include <map>

namespace atdISFF {

/**
 * A RelaySequence is a series of RelaySettings, each with
 * a duration in seconds.
 */
class RelaySequence : public std::vector<std::pair<RelaySetting,int> > {

public:
  const std::string& getName() const { return name; }
  void setName(const std::string& val) { name = val; }

  void addSetting(RelaySetting& setting, int seconds) {
    push_back(std::pair<RelaySetting,int>(setting,seconds));
  }

  /**
   * Return ith RelaySetting.
   */
  const RelaySetting& getSetting(int i) const {
    return operator[](i).first;
  }

  /**
   * Return duration of a setting.
   */
  int getDuration(int i) const {
    return operator[](i).second;
  }

  /**
   * Compute duration of this sequence, in seconds.
   */
  int getDuration() const {
    int duration = 0;
    for (unsigned int i = 0; i < size(); i++)
    	duration += getDuration(i);
    return duration;
  }

private:
  std::string name;
};

}

#endif
