//
//              Copyright 2004 (C) by UCAR
//

#ifndef ATDISFF_RELAYPROGRAM_H
#define ATDISFF_RELAYPROGRAM_H

#include <atdISFF/relays/RelaySequence.h>
#include <atdISFF/RawSampleSource.h>
#include <atdISFF/TimerThread.h>
#include <atdISFF/Relay.h>

namespace atdISFF {

class RelayProgram : public std::vector<std::pair<RelaySequence,unsigned int> >,
	public atdUtil::Runnable, public atdISFF::RawSampleSource {

public:

  RelayProgram();

  const std::string& getName() const { return name; }
  void setName(const std::string& val) { name = val; }

  void addSequence(RelaySequence& sequence, int repeat) {
    push_back(std::pair<RelaySequence,int>(sequence,repeat));
  }

  /**
   * Return ith RelaySequence
   */
  const RelaySequence& getSequence(int i) const {
    return operator[](i).first;
  }

  /**
   * Return duration of a single execution of a sequence, in seconds.
   */
  int getDuration(int i) const {
    return operator[](i).first.getDuration();
  }

  /**
   * Number of times a sequence is repeated.
   */
  unsigned int getRepeat(int i) const {
    return operator[](i).second;
  }

  /**
   * Compute duration of this program, in seconds.
   */
  int getDuration() const {
    int duration = 0;
    // multiply sequences by their repeat value
    for (unsigned int i = 0; i < size(); i++)
      duration += getDuration(i) * getRepeat(i);
    return duration;
  }

  void setRelay(Relay* val) { relay = val; }
  Relay* getRelay() const { return relay; }

  void setOverride(bool val) throw(atdUtil::IOException);
  bool getOverride() const { return override; }

  void setTimerThread(TimerThread* val) { timer = val; }

  int run() throw(atdUtil::Exception);

  const RelaySetting& getCurrentSetting() const;

  int getCurrentDuration() const;

  /**
   * Increment step pointer in program. Return false if at end of program
   */
  bool step();

  /**
   * Reset program to beginning.
   */
  void reset();

  /**
   * Get RelaySetting of the current program step.
   */
  const RelaySetting& getSetting() const;

  /**
   * Get duration of the current program step.
   */
  int getSettingDuration() const;

  void interrupt() { interrupted = true; }

  bool isInterrupted() const { return interrupted; }

  void setChannel(int val) { channel = val; }
  int getChannel() const { return channel; }

protected:

  bool amInterrupted() const {
    testCancel();
    return interrupted;
  }

private:

  std::string name;

  Relay* relay;

  atdUtil::Mutex overrideLock;

  TimerThread* timer;

  unsigned int repNum;
  unsigned int seqNum;
  unsigned int setNum;

  bool interrupted;

  int nsamples;

  bool override;
  bool override_end;

  int channel;
};

}

#endif
