//
//              Copyright 2004 (C) by UCAR
//

#ifndef ATDISFF_RELAYPARSER_H
#define ATDISFF_RELAYPARSER_H

#include <atdISFF/relays/RelayProgram.h>
#include <atdUtil/EOFException.h>
#include <atdUtil/IOException.h>
#include <atdUtil/ParseException.h>
#include <atdUtil/InvalidParameterException.h>

namespace atdISFF {

class RelayParser {

public:
  RelayParser() : fp(0),lineno(0) {}
  ~RelayParser();

  void parse(const std::string& filename)
  	throw(atdUtil::IOException,atdUtil::ParseException);

  std::vector<std::string> getProgramNames() const {
    return programNames;
  }

  RelayProgram& getProgram(const std::string& name) throw(atdUtil::InvalidParameterException) {
    std::map<std::string,RelayProgram>::iterator mi =
      programs.find(name);
    if (mi == programs.end())
    	throw atdUtil::InvalidParameterException("RelayParser::getProgram",
		name,"no such program name");
    return mi->second;
  }

  /**
   * Test program.
   */
  static int main(int argc, char** argv);

  static int usage(const char* argv0);

private:

  void pushfile(const std::string& fname) throw(atdUtil::IOException);
  void popfile() throw(atdUtil::EOFException);

  void readLine() throw(atdUtil::IOException,atdUtil::EOFException);
  const char* skipWhite();
  bool skipTilEOL();

  void parseSettings() throw(atdUtil::IOException, atdUtil::ParseException);
  void parseSequence() throw(atdUtil::IOException, atdUtil::ParseException);
  void parseProgram() throw(atdUtil::IOException, atdUtil::ParseException);

  std::string filename;
  FILE *fp;
  int lineno;

  std::vector<std::string> filenames;
  std::vector<FILE*> fps;
  std::vector<int> linenos;

  char linebuf[1024];
  const char* curptr;

  std::map<std::string,RelaySetting> settings;
  std::map<std::string,RelaySequence> sequences;
  std::map<std::string,RelayProgram> programs;
  std::vector<std::string> programNames;

};

}

#endif
