//
//              Copyright 2004 (C) by UCAR
//

#ifndef ATDISFF_OPTO22RELAY_H
#define ATDISFF_OPTO22RELAY_H

#include <atdISFF/Relay.h>
#include <atdTermio/SerialPort.h>
#include <atdUtil/BitArray.h>

namespace atdISFF {

/**
 * An implementation of a Relay - an Opto22 board connected
 * to a serial port.
 */
class Opto22Relay : public Relay , public atdTermio::SerialPort {

public:
  Opto22Relay(const std::string& ttyDev);

  const std::string& getName() const { return SerialPort::getName(); }

  void setRelayBits(const atdUtil::BitArray& val) { bits = val; }
  void setRelays() throw(atdUtil::IOException);

  atdUtil::BitArray& readRelays() throw(atdUtil::IOException);
  atdUtil::BitArray& getRelayBits() { return bits; }

  void openRelays() throw(atdUtil::IOException);
  void reset() throw(atdUtil::IOException);

  void write(const char* buf) throw(atdUtil::IOException);

private:
  void open() throw(atdUtil::IOException);
  atdUtil::BitArray bits;

  int NBYTES;

  bool overridden;
};

}

#endif
  
