//
//              Copyright 2004 (C) by UCAR
//
  
#include <atdISFF/relays/Opto22Relay.h>
#include <sstream>
#include <iomanip>
#include <time.h>		// nanosleep

using namespace atdISFF;
using namespace std;

Opto22Relay::Opto22Relay(const string& ttyDev) :
	SerialPort(ttyDev),bits(16) {
  NBYTES = bits.getLengthInBytes();
  setBaudRate(9600);
  setParity(atdTermio::SerialPort::NONE);
  setDataBits(8);
  setStopBits(1);
  setLocal(true);
  setRaw(false);
  setFlowControl(atdTermio::SerialPort::NOFLOWCONTROL);
}

void Opto22Relay::open() throw(atdUtil::IOException) {
  SerialPort::open(O_WRONLY  | O_NOCTTY);
  reset();
}

void Opto22Relay::setRelays() throw(atdUtil::IOException) {
  ostringstream ost;
  ost << ">00J" << setfill('0') << hex;
  for (int i = NBYTES; i-- > 0 ; ) {
    if (i >= bits.getLengthInBytes()) ost << setw(2) << 0;
    else ost << setw(2) << (unsigned int)bits.getPtr()[i];
  }
  ost << "??\r";
  write(ost.str().c_str());
}

/**
 * Can we read current Opto22 settings? Dunno
 */
atdUtil::BitArray& Opto22Relay::readRelays() throw(atdUtil::IOException) {
  // assume we can't read, just return current bits.
  return getRelayBits();
}

/**
 */
void Opto22Relay::openRelays() throw(atdUtil::IOException)
{
  bits.setBits(false);
  setRelays();
}

/**
 * Reset the OPTO22, set all ports to output mode
 */
void Opto22Relay::reset() throw(atdUtil::IOException)
{
  /* reset command:  >00B??cr  */
  write(">00B??\r");

  struct timespec t;
  t.tv_sec = 0;
  t.tv_nsec = 500000000l;	// 500 million nanosec = 1/2 second
  nanosleep(&t,0);

  /* set ports to output mode: >00GFFFF??cr */
  write(">00GFFFF??\r");
  nanosleep(&t,0);
  return;	
}

/**
 * write all of string.
 */
void Opto22Relay::write(const char* buf) throw(atdUtil::IOException) {
  if (fd() < 0) open();
  register const char* cp = buf;
  register const char* ep = cp + strlen(buf);
  for ( ; cp < ep; ) cp += SerialPort::write(cp,ep-cp);
}
