//
//              Copyright 2004 (C) by UCAR
//

#include <atdISFF/licor820/Licor820SensorPort.h>
#include <atdISFF/RawSample.h>
#include <atdUtil/Logger.h>

#include <fstream>

using namespace atdISFF;
using namespace atdUtil;
using namespace std;

Licor820SensorPort::Licor820SensorPort(const string portName,int channel)
  throw (atdUtil::IOException) :AsciiSensorPort(portName,channel),
	parser(0),handler(0)
{
}

Licor820SensorPort::~Licor820SensorPort() {
  if (parser) delete parser;
  if (handler) delete handler;
}

void Licor820SensorPort::init() throw(atdUtil::IOException) {
  AsciiSensorPort::init();

  handler = new Licor820SAX2Handler();
  handler->setSensorPort(this);
  parser = new XMLSAX2Parser(handler);

  if (initFile.size() > 0) sendInitFile();
}

void Licor820SensorPort::sendInitFile() throw(atdUtil::IOException) {
  std::ifstream xmlfile(initFile.c_str());
  if (!xmlfile) throw atdUtil::IOException(initFile,"open",errno);

  char buf[1024];
  while(xmlfile) {
    xmlfile.getline(buf,sizeof(buf)-1);	// save room for appending newline
    int l = strlen(buf);
    buf[l] = '\n';
    write(buf,l+1);
  }
}

void Licor820SensorPort::processInput(isff_sys_time_t rtime,const char *charP) throw(IOException)
{
  // after scan, rtime is time of first sample.
  rtime = scanForSamples(rtime,charP);

  if (samplePointers.size() > 0) {
    list<const char*>::const_iterator sitr = samplePointers.begin();
    list<const char*>::const_iterator send = samplePointers.end();
    const char* p1 = *sitr;
    const char* p2;
    int is = 0;
    int len;
    for (; sitr != send; ) {
      sitr++;
      if (sitr == send) p2 = scanPtr;
      else p2 = *sitr;
      len = p2 - p1 - 1;	// one character EOM

      sampleTime = sample_time(rtime,(is++ * deltatms));

      try {
	parser->parse(p1,len);
      }
      // note this doesn't try to parse successive samples, just gives up
      catch (ParseException &pe) {
	shiftBuffer();
	throw IOException(getName(),"parse",pe.what());
      }
      p1 = p2;
    }
  }
  shiftBuffer();
}

