//
//              Copyright 2004 (C) by UCAR
//

#ifndef ATDISFF_LICOR820SAX2HANDLER_H
#define ATDISFF_LICOR820SAX2HANDLER_H

#include <atdUtil/XMLSAX2Handler.h>

namespace atdISFF {

class Licor820SensorPort;

class Licor820SAX2Handler : public atdUtil::XMLSAX2Handler {
protected:
  enum elementType { UNKNOWN, LI820, ACK, DATA, CELLTEMP, CELLPRES, CO2 };
public:
  Licor820SAX2Handler();

  /** test function */
  static int Licor820SAX2Handler::test(const char* teststring);

  void setSensorPort(Licor820SensorPort* val);
    
  int startDocumentHandler();

  int endDocumentHandler();

  int startElementHandler(const XMLCH *uri, const XMLCH *localname,
    const XMLCH *qname, LPXMLVECTOR atts);

  int endElementHandler( const XMLCH *uri, const XMLCH *localname,
    const XMLCH *qname);

  int charactersHandler(const XMLCH* chars,int length);

  elementType unknownElement();

  float getCellTemp() const { return celltemp; }
  float getCellPres() const { return cellpres; }
  float getCO2() const { return co2; }

protected:

  Licor820SensorPort* licor;

  float celltemp;
  float cellpres;
  float co2;
  float floatnan;

  elementType nextElement;

  int unknownElements;

};

}

#endif


