//
//              Copyright 2004 (C) by UCAR
//

#include <atdISFF/licor820/Licor820SAX2Handler.h>
#include <atdISFF/licor820/Licor820SensorPort.h>
#include <atdUtil/Logger.h>
#include <atdISFF/RawSample.h>

#include <math.h>

using namespace std;
using namespace atdISFF;
using namespace atdUtil;

// #define DEBUG

Licor820SAX2Handler::Licor820SAX2Handler() :
    licor(0),floatnan(nanf("")),unknownElements(0)
{
}

void Licor820SAX2Handler::setSensorPort(Licor820SensorPort* val)
{
  licor = val;
}

int Licor820SAX2Handler::startDocumentHandler() {
  celltemp = cellpres = co2 = floatnan;
#ifdef DEBUG
  cerr << "startDocument" << endl;
#endif
  return XML_OK;
}

int Licor820SAX2Handler::endDocumentHandler()
{

#ifdef DEBUG
  cerr << "endDocument" << endl;
  return XML_OK;
#endif


  if (licor) {
    if (isnan(co2) && isnan(cellpres) && isnan(celltemp)) return XML_OK;

    int len = 3 * sizeof(float);
    RawSample *sample =
      RawSamplePool::getInstance()->getRawSample(len);

    sample->tt = licor->getSampleTime();
    sample->chan = 200;
    sample->len = (unsigned char) len;
    char* dp = sample->data;
    ::memcpy(dp,&co2,sizeof(float));
    dp += sizeof(float);
    ::memcpy(dp,&cellpres,sizeof(float));
    dp += sizeof(float);
    ::memcpy(dp,&celltemp,sizeof(float));
    dp += sizeof(float);
    licor->distribute(sample);
  }
  return XML_OK;
}

Licor820SAX2Handler::elementType
Licor820SAX2Handler::unknownElement() 
{
  if (!(unknownElements++ % 100))
    if (licor)
      atdUtil::Logger::getInstance()->log(LOG_WARNING,
      	"%d unknown XML elements received from %s",
	unknownElements,licor->getName().c_str());
    else
      atdUtil::Logger::getInstance()->log(LOG_WARNING,
      	"%d unknown XML elements received",unknownElements);
  return UNKNOWN;
}

int Licor820SAX2Handler::startElementHandler(
  const XMLCH *uri,
  const XMLCH *localname,
  const XMLCH *qname,
  LPXMLVECTOR atts)
{

#ifdef DEBUG
  cerr << "startElement: uri=" << uri <<
  	" localname=" << localname <<
	" qname=" << qname << endl;
#endif

  switch (qname[0]) {
    case 'l':
      nextElement = LI820;
      break;
    case 'a':
      nextElement = ACK;
      break;
    case 'd':
      nextElement = DATA;
      break;
    case 'c':	// CO2, CELLTEMP or CELLPRES
      switch (qname[1]) {
	case 'e':	// CELLTEMP or CELLPRES
	  if (!strcmp((const char*)qname,"celltemp")) nextElement = CELLTEMP;
	  else if (!strcmp((const char*)qname,"cellpres")) nextElement = CELLPRES;
	  else nextElement = unknownElement();
	  break;
	case 'o':
	  if (!strcmp((const char*)qname,"co2")) nextElement = CO2;
	  else nextElement = unknownElement();
	  break;
	default: 
	  nextElement = unknownElement();
	  break;
      }
      break;
  }
  return XML_OK;
}

int Licor820SAX2Handler::endElementHandler(
  const XMLCH *const   	  uri,		// namespace
  const XMLCH *const  	  localname,	// local part of name
  const XMLCH *const  	  qname)	// QName 
{

#ifdef DEBUG
  cerr << "endElement: uri=" << uri <<
  	" localname=" << localname <<
	" qname=" << qname << endl;
#endif
  return XML_OK;
}

int Licor820SAX2Handler::charactersHandler(const XMLCH* chars,
	int length) {

#ifdef DEBUG
  cerr << "characters: \"";
  for (int i = 0; i < length; i++) cerr << chars[i];
  cerr << "\"" << endl;
#endif
  
  // unsigned char* tchars = new unsigned char[length + 1];
  char tchars[length + 1];
  strncpy(tchars,(const char*)chars,length);
  tchars[length] = '\0';

  switch (nextElement) {
    case CELLTEMP:
      if (sscanf(tchars,"%f",&celltemp) != 1) celltemp = floatnan;
      break;
    case CELLPRES:
      if (sscanf(tchars,"%f",&cellpres) != 1) cellpres = floatnan;
      break;
    case CO2:
      if (sscanf(tchars,"%f",&co2) != 1) co2 = floatnan;
      break;
#ifdef DEBUG
    case ACK:
      cerr << "received: ACK " << (const char*) tchars << endl;
      break;
#endif
  }
  // delete [] tchars;
  return XML_OK;
}

/**
 * Test entry point.
 */
int Licor820SAX2Handler::test(const char* teststring) {
  Licor820SAX2Handler handler;
  XMLSAX2Parser parser(&handler);

  for (int j = 0; j < 10; j++) {
    for (int i = 0; i < 10000; i++) {
      try {
	parser.parse(teststring,strlen(teststring));
      }
      catch (ParseException &pe) {
	cerr << pe.what() << endl;
      }
    }
    cerr << "sleep(10)" << endl;
    sleep(10);
  }
}
