//
//              Copyright 2004 (C) by UCAR
//

#include <atdISFF/licor820/Licor820Prompter.h>
#include <atdUtil/Logger.h>

using namespace atdISFF;
using namespace atdUtil;
using namespace std;

Licor820Prompter::Licor820Prompter(Licor820SensorPort* l,TimerThread* t) :
  Thread(string("Licor820Prompter(") + l->getName() + ")"),
  	licor(l),timer(t)
{
}

int Licor820Prompter::run() throw(atdUtil::Exception) {

  const char* cmd = "<LI820><DATA>?</DATA></LI820>\n";
  int lcmd = strlen(cmd);
  const char* eoc = cmd + lcmd;

  for (;;) {
    if (isInterrupted() || timer->isInterrupted()) {
      Logger::getInstance()->log(LOG_INFO,"%s",
	  "Licor820Prompter::run interrupted");
      break;
    }
    timer->lock();
    timer->wait();
    if (isInterrupted() || timer->isInterrupted()) {
      Logger::getInstance()->log(LOG_INFO,"%s",
	  "Licor820Prompter::run timer interrupted");
      timer->unlock();
      break;
    }
    timer->unlock();
    // cerr << "Licor820Prompter woken" << endl;

    for(const char* p = cmd; p < eoc; p += licor->write(p,eoc - p));
  }
  return RUN_OK;
}
