/*              Copyright 2004 (C) by UCAR
 *
 * File       : AirCOASampler.h,v
 * Revision   : 1.16
 * Directory  : /code/cvs/isa/src/lib/atdISFF/licor820/AirCOASampler.h,v
 * System     : PAM
 * Date       : 2007/03/21 22:16:31
 *
 * Description:
 *
 *
 */
                                                                                
#ifndef ATDISFF_AIRCOASAMPLER_H
#define ATDISFF_AIRCOASAMPLER_H

/* for strsignal */
#ifndef _GNU_SOURCE
#define _GNU_SOURCE
#endif
#include <string.h>
#include <signal.h>

#include <atdISFF/Sampler.h>
#include <atdISFF/RawSampleBuffer.h>
#include <atdISFF/RawSampleSocket.h>
#include <atdISFF/SensorPortHandler.h>
#include <atdISFF/TimerThread.h>
#include <atdISFF/UserClockedA2DSampler.h>
#include <atdISFF/licor820/Licor820Prompter.h>
#include <atdISFF/licor820/Licor820SensorPort.h>
#include <atdISFF/SampleFormatter.h>
#include <atdISFF/AsciiRawSampleOutputStream.h>
#include <atdISFF/relays/RrelayListener.h>
#include <atdISFF/AsciiSampleArchiver.h>

#include <atdISFF/relays/RelayProgram.h>
#include <dsc/IR104.h>

// #include <atdISFF/DaqMonitorRPC.h>

#include <iostream>
#include <string>
#include <time.h>


namespace atdISFF {
class AirCOASampler : public Sampler {

protected:

  AirCOASampler();

  const std::string& getName() const { return _name; }

  void setupSignals();
  void createTimer();
  void startLicor820Serial(const std::string& ttyDev)
  	throw(atdUtil::Exception);
  void startRelays() throw(atdUtil::Exception);
  void startA2D() throw(atdUtil::Exception);

  void setArchiveValues(std::string& archiveDir,
		std::string& archiveFormat,
		int archiveLengthSecs);

  void createArchiver();


public:

  ~AirCOASampler();

  void init() throw(atdUtil::Exception);

  static const std::string& getVersion();

  void setNodeName(const std::string& val) { _nodename = val; }
  const std::string& getNodeName() const { return _nodename; }

  void setDataServerName(const std::string& val) { _servername = val; }
  const std::string& getDataServerName() const { return _servername; }

  void setTtyOutDev(const std::string& val) { _ttyOutDev = val; }
  const std::string& getTtyOutDev() const { return _ttyOutDev; }

  void setLicor820InitFile(const std::string& val) { _licor820InitFile = val; }
  const std::string& getLicor820InitFile() const { return _licor820InitFile; }

  void setA2DConfigFile(const std::string& val) { _a2dConfigFile = val; }
  const std::string& getA2DConfigFile() const { return _a2dConfigFile; }


#if defined(ENABLE_DSCUD)
  void setIR104Relay(RelayProgram* relayProg, int ioport) throw(atdUtil::IOException);
#endif

  atdISFF::RawSampleSocket* getRawSampleSocket() const { return _outputSocket; }
  atdISFF::RawSampleBuffer* getRawSampleBuffer() const { return _rsbuffer; }
  atdISFF::SensorPortHandler* getSensorPortHandler() const { return _sphandler; }
  atdISFF::A2DSampler* getA2DSampler() const { return _a2dsampler; }

  void addA2DChannel(const std::string& name,int num,float vmin, float vmax, float rate) throw (atdUtil::IOException,atdUtil::InvalidParameterException);

  void addVariable(SampleFormatter::varType type,const std::string& name, int num);

  void addVariable(SampleFormatter::varType type,const std::string& name, int num,float a2dslope, float a2dintercept);

  float getMaximumA2DSamplingRate() const;
  const std::vector<const float*>& getAvailableA2DVoltageRanges() const;

  static int main(int argc, char **argv);

  void wait();
  void interrupt();
  void quit();

  bool getQuit() const { return _quit; }

  time_t getStartTime() const { return _startTime; }
  time_t getRestartTime() const { return _restartTime; }

  float getSampleRate() const { return _sampleRate; }
  void setSampleRate(float val) { _sampleRate = val; }

  RawSampleArchiver* getRawSampleArchiver() const { return _archiver; }

protected:

  static void sigAction(int sig, siginfo_t* siginfo, void* vptr);
  static AirCOASampler* _instance;

  static const std::string _version;

  /**
   * Start time of main routine
   */
  static time_t _startTime;

  std::string _name;

  bool _quit;

  std::string _nodename;

  std::string _servername;

  std::string _ttyOutDev;

  std::string _licor820InitFile;

  std::string _a2dConfigFile;

  atdISFF::SensorPortHandler* _sphandler;

  atdISFF::UserClockedA2DSampler* _a2dsampler;

  atdISFF::Licor820Prompter* _licorPrompter;

  RawSampleBuffer* _rsbuffer;

  atdISFF::TimerThread* _timer;

  RawSampleSocket* _outputSocket;

  SampleFormatter* _sampleFormatter;

  AsciiSampleArchiver* _archiver;

  atdTermio::SerialPort* _outputSerialPort;

  __gnu_cxx::stdio_filebuf<char> *_outputBuffer;

  std::ostream* _outputStream;

  AsciiRawSampleOutputStream* _aircoaOutputStream;

  /**
   * The RelayProgram that we execute.
   */
  RelayProgram* _relayProgram;

  atdISFF::Licor820SensorPort* _licorSensor;

  /**
   * The thread that run the RelayProgram and operate the relays.
   */
  atdUtil::ThreadRunnable* _relayThread;

  /**
   * The relays we operate.
   */
  Relay* _relay;

  atdISFF::RrelayListener* _rrelayListener;

  /**
   * Start time of this Sampler.
   */
  time_t _restartTime;

  std::string archiveDir;

  std::string archiveFormat;

  int archiveLengthSecs;

  bool _privileged;

  float _sampleRate;

};
}
#endif
