/*              Copyright (C) 2004 by UCAR
 *
 * File       : daqmonitor.x,v
 * Revision   : 1.11
 * Directory  : /code/cvs/isa/src/lib/atdISFF/daqmonitor.x,v
 * Date       : 2006/02/27 00:17:03
 *
 * Description:
 * rpcgen source for adamserver clients and servers.
 */

#ifdef RPC_HDR
%#ifndef ATDISFF_DAQMONITOR_H
%#define ATDISFF_DAQMONITOR_H
#endif

%#include <config.h>

struct sensorPortStatus {
  sensorPortStatus* next;
  string devname<>;
  int channelNum;
  int baudRate;
  string parity<>;
  int dataBits;
  int stopBits;
  string flowcontrol<>;
  string messageSeparator<>;
  int separatorAtEOM;
  int messageLength;

  float readsPerSecond;
  float samplesPerSecond;
  int minReadLength;
  int maxReadLength;
  int readErrorCount;
  int writeErrorCount;
  int cumReadErrorCount;
  int cumWriteErrorCount;
  int bufferOverflowCount;
  int cumBufferOverflowCount;
};

struct a2dStatus {
  long missedSamples;
  long cumulativeMissedSamples;
  float totalSamplesPerSec;
  float userInterruptRate;
};

struct a2dChannelStatus {
  a2dChannelStatus *next;
  int channelNum;
  float sampleRate;
  float minV;
  float maxV;
  float uVresolution;
};

struct daqStatus {
  long currentTimeSecs;
  long currentTimeUsecs;
  unsigned long startTime;
  unsigned long restartTime;
  int lostSamples;
  int numWriteErrors;
  int numWriteTempUnavailable;
  int maxWriteLength;
  int minWriteLength;
  int bytesPerSec;
  float samplesPerSec;
  unsigned long rawSampleSetSize;
  unsigned long rawSamplesInMemory;
  unsigned long badArchiveTimeTags;
  /* rpcgen chokes on "version" */
  string softversion<>;
  a2dStatus a2d;
  a2dChannelStatus* a2ds;
  sensorPortStatus* ports;
};

union daqStatus_res switch (int ierr) {
  case 0:
    daqStatus status;
  default:
    string errmsg<>;
};

/* paramater for call to daqMotor_1_svc */
struct daqMotorCmd {
   int motorNumber;
   unsigned long command;
   double arg1;
};

/* return structure for call to daqMotor_1_svc. */
struct daqMotorStatus {
   bool cmdSuccess;
   int status;
   double position;
};

/* The status value is unionized with a error indicator for the 
   return value from daqMotor_1_svc */
union daqMotor_res switch (int ierr) {
  case 0:
    daqMotorStatus status;
  default:
    string errmsg<>;
};

program DAQMONITOR_PROG {
  version DAQMONITOR_VERS {
    daqStatus_res DAQSTATUS(void) = 1;
    void DAQRESTART(void) = 2;
    void DAQSTOP(void) = 3;
    daqMotor_res DAQMOTOR(daqMotorCmd) = 4;
  } = 1;
} = 0x20000100;

#ifdef RPC_HDR
%#endif
#endif
