/*              Copyright (C) 1989,90,91,92,93,94 by UCAR
 *
 * File       : adamserver.x,v
 * Revision   : 1.3
 * Directory  : /code/cvs/isa/src/lib/atdISFF/adamserver.x,v
 * Date       : 2005/12/07 01:04:53
 *
 * Description:
 * rpcgen source for adamserver clients and servers.
 *
 * adamserver primarily does as it's named: serves ASTER ADAMS.
 * It runs on the UNIX host, providing configuration and time
 * information to the ADAMS.
 * Upon request, it returns the serial port and analog port
 * configurations in the form of structures, integer and string
 * values of configuration parameters, the current time (an rdate
 * emulation), and its current settings of the PROJECT and OPS
 * environment variables.
 *
 * Updates    : adamserver.x,v
 * Updates    : Revision 1.3  2005/12/07 01:04:53  maclean
 * Updates    : *** empty log message ***
 * Updates    :
 * Updates    : Revision 1.2  2004/10/02 02:58:53  maclean
 * Updates    : *** empty log message ***
 * Updates    :
 * Updates    : Revision 1.1.1.1  2004/03/18 14:49:51  maclean
 * Updates    : first import
 * Updates    :
 * Updates    : Revision 1.6  2000/10/18 18:39:18  maclean
 * Updates    : *** empty log message ***
 * Updates    :
# Revision 1.5  1999/09/03  16:02:26  maclean
# Added BINARY_END_SYNC datarectype, and etc_hosts RPC call
#
 * Updates    : Revision 1.4  1999/07/06 18:45:10  maclean
 * Updates    : return error strings when ierr!=0 in return structures
 * Updates    :
# Revision 1.3  1999/06/11  20:45:46  aster
# *** empty log message ***
#
 * Updates    : Revision 1.2  1999/06/03 22:55:36  maclean
 * Updates    : Added support for ttl output config
 * Updates    :
# Revision 1.1  1998/06/08  21:23:25  maclean
# initial checkin
#
 *
 */

#ifdef RPC_HDR
%#ifndef ADAMSERVER_H
%#define ADAMSERVER_H
%#include <time.h>
#endif

enum datarectype {ASCII,BINARY,PROMPTEDBINARY,BINARY_END_SYNC};

struct siocfg {
  siocfg * next;
  int baud;		/* baud rate */
  unsigned long c_cflag;/* from termios.h */
  string fmt<>;		/* sscanf format */
  string sync<>;	/* sync string for binary input */
  unsigned char chan;	/* adam channel number: 200-255 */
  unsigned char eom;	/* end of message character */
  unsigned char nfields;/* number of fields to decode */
  unsigned short nbytes;/* number of bytes in binary record */
  datarectype type;		/* type of input, ASCII or BINARY */
};

union siocfg_res switch (int ierr) {
  case 0:
    siocfg *sio;
  default:
    string errmsg<>;
};

union configint_res switch (int ierr) {
  case 0:
    int value;
  default:
    string errmsg<>;
};

union configstring_res switch (int ierr) {
  case 0:
    string value<>;
  default:
    string errmsg<>;
};

const MAXSTRINGLEN = 255;

struct analogcfg {
  analogcfg * next;
  unsigned char chan;	/* adam channel number: 000-199 */
  int hz;		/* data rate */
  float gain;
  float offset;
};

union analogcfg_res switch (int ierr) {
  case 0:
    analogcfg *a2d;
  default:
    string errmsg<>;
};

struct blazingArchive {
  string adamName<>;
  string server<>;
  string tapeDevice<>;
  int status;
};

union blazingArchive_res switch (int ierr) {
  case 0:
    blazingArchive bA;
  default:
    string errmsg<>;
};

struct ttl_output_cfg {
  long start;
  long on;
  long off;
  int chan;
  ttl_output_cfg * next;
};

union ttl_output_cfg_res switch (int ierr) {
  case 0:
    ttl_output_cfg *ttl;
  default:
    string errmsg<>;
};

struct etc_hosts_entry {
  string addr<>;		/* address from /etc/hosts */
  string name<>;		/* hostname from /etc/hosts */
  etc_hosts_entry * next;
};

union etc_hosts_res switch (int ierr) {
  case 0:
    etc_hosts_entry *host;
  default:
    string errmsg<>;
};

program ADAMSERVERPROG {
  version ADAMSERVERVERS {
    siocfg_res GETSIOCFG(string) = 1;
    configint_res CONFIGINT(string) = 2;
    long RDATE(void) = 3;
    string GETADAMSERVERENV(string) = 4;
    analogcfg_res GETANALOGCFG(string) = 5;
    long RGMTMSECS(void) = 6;
    configstring_res CONFIGSTRING(string) = 7;
    int STARTBLAZINGTAPE(blazingArchive) = 8;
    int STOPBLAZINGTAPE(blazingArchive) = 9;
    blazingArchive_res GETBLAZINGSTATUS(string) = 10;
    int STARTBLAZINGDISK(blazingArchive) = 11;
    int STOPBLAZINGDISK(blazingArchive) = 12;
    ttl_output_cfg_res GET_TTL_OUTPUT_CFG(string) = 13;
    etc_hosts_res ETC_HOSTS(void) = 14;
  } = 1;
} = 0x20000001;

#ifdef RPC_HDR
%#endif
#endif
